package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.EventTrigger
import joyfill.fields.TableField
import joyfill.fields.table.Row
import joyfill.fields.table.TextColumn
import joyfill.table.TextCellEditor

internal class TextCellEditorImpl(
    document: Document,
    field: TableField,
    override val column: TextColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : EventTrigger<TableField>(document, field, onChange), TextCellEditor {

    override val text by lazy { mutableLiveOf(row.cells[column.id] as? String) }

    override fun set(value: String?) {
        text.value = value
        row.cells[column.id] = value
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }
}