package joyfill.table.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.IdentityGenerator
import joyfill.editors.internal.EventTrigger
import joyfill.fields.TableField
import joyfill.fields.table.ImageColumn
import joyfill.fields.table.Row
import joyfill.table.ImageCellEditor
import joyfill.utils.Attachment
import joyfill.utils.JsonList
import joyfill.utils.toAttachment

internal class ImageCellEditorImpl(
    document: Document,
    field: TableField,
    val identity: IdentityGenerator,
    override val column: ImageColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : EventTrigger<TableField>(document, field, onChange), ImageCellEditor {
    override val value: MutableList<Attachment> = run {
        if (row.cells[column.id] == null) {
            row.cells[column.id] = mutableListOf<MutableMap<String, Any?>>()
        }
        JsonList(row.cells[column.id]) { it.toAttachment() }
    }

    override fun add(url: String) = add(listOf(url))

    override fun add(urls: List<String>) {
        val attachments = urls.map { Attachment(id = identity.generate(), it) }
        value.addAll(attachments)
        notifyChange()
    }

    override fun set(urls: List<String>) {
        val attachments = urls.map { Attachment(id = identity.generate(), it) }
        value.clear()
        value.addAll(attachments)
        notifyChange()
    }

    override fun remove(key: String?) {
        if (key == null) return
        remove(listOf(key))
    }

    override fun remove(keys: List<String>) {
        val found = value.filter { it.id in keys || it.url in keys || it.fileName in keys }
        if (found.isEmpty()) return
        value.removeAll(found)
        notifyChange()
    }

    private fun notifyChange() {
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }
}