package joyfill.table

import cinematic.Live
import joyfill.fields.table.Row

interface RowCollection {
    val size: Int
    val state: Live<RowState>

    fun all(): List<RowEditor>
    fun create(): RowEditor
    fun append(): RowEditor

    @Deprecated("Ditch index based, In favour of overload with id")
    fun addAfter(index: Int): RowEditor
    fun addAfter(id: String): RowEditor

    @Deprecated("Ditch index based, In favour of overload with id")
    fun addBefore(index: Int): RowEditor
    fun addBefore(id: String): RowEditor

    @Deprecated("Ditch index based, In favour of overload with id")
    fun addAt(index: Int): RowEditor

    @Deprecated("Ditch index based, In favour of overload with id")
    fun duplicate(index: Int): Row?

    fun duplicate(keys: List<String>): List<RowEditor>

    fun duplicate(): List<RowEditor>

    fun get(index: Int): RowEditor?

    fun get(id: String): RowEditor?

    @Deprecated("Ditch index based, In favour of overload with id")
    fun deleteAt(index: Int): Row?

    fun delete(keys: List<String>): List<Row>

    fun delete()

    @Deprecated("Ditch index based, In favour of overload with RowEditor")
    fun select(index: Int): RowEditor?

    fun select(row: RowEditor?): RowEditor?

    fun isSelected(index: Int): Boolean
    fun isSelected(row: RowEditor?): Boolean

    fun unselect(index: Int): RowEditor?

    fun unselect(row: RowEditor?): RowEditor?

    fun selectAll()
    fun unSelectAll()
    fun selection(): Selection

    fun selected(): List<RowEditor>

    val move: RowMover
}