package joyfill.table

import joyfill.fields.table.Column

data class ColumnState(
    val current: ColumnFilter?,
    val filters: List<ColumnFilter>
) {
    fun isFiltered(c: Column?): Boolean = when (val filter = filters.find { it.column.id == c?.id }) {
        is ColumnFilter.TextColumnFilter -> !filter.value.isNullOrBlank() || filter.sort != SortingOption.None
        is ColumnFilter.DropdownColumnFilter -> filter.value != null || filter.sort != SortingOption.None
        else -> false
    }
}