package joyfill.table

import joyfill.fields.table.Column
import joyfill.fields.table.DropdownColumn
import joyfill.fields.table.TextColumn
import joyfill.utils.Option2

sealed interface ColumnFilter {
    val column: Column
    val sort: SortingOption
    val value: Any?

    data class TextColumnFilter(
        override val column: TextColumn,
        override val sort: SortingOption,
        override val value: String?
    ) : ColumnFilter

    data class DropdownColumnFilter(
        override val column: DropdownColumn,
        override val sort: SortingOption,
        override val value: Option2?
    ) : ColumnFilter

    fun sorted(option: SortingOption?): ColumnFilter = when (this) {
        is DropdownColumnFilter -> copy(sort = option ?: SortingOption.None)
        is TextColumnFilter -> copy(sort = option ?: SortingOption.None)
    }
}