package joyfill.editors.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.collections.PageCollection
import joyfill.editors.FieldEditor
import joyfill.fields.Field
import joyfill.fields.VField
import joyfill.validation.FieldValid
import joyfill.validation.FieldValidity

@PublishedApi
internal class UnknownFieldEditor(
    document: Document,
    override val field: VField,
    pages: PageCollection,
    dispatcher: EventDispatcher,
    onChange: ((ChangeEvent) -> Unit)?
) : AnyFieldEditor<VField>(document, field, pages, dispatcher, onChange), FieldEditor {
    override fun validate(): FieldValidity = FieldValid(field, emptyList())
}