package joyfill.editors.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.IdentityGenerator
import joyfill.collections.PageCollection
import joyfill.editors.TableFieldEditor
import joyfill.fields.TableField
import joyfill.fields.table.DropdownColumn
import joyfill.fields.table.ImageColumn
import joyfill.fields.table.Row
import joyfill.fields.table.TextColumn
import joyfill.table.TableState
import joyfill.table.internal.ColumnCollectionImpl
import joyfill.table.internal.RowCollectionImpl

@PublishedApi
internal class TableFieldEditorImpl(
    document: Document,
    override val field: TableField,
    identity: IdentityGenerator,
    pages: PageCollection,
    dispatcher: EventDispatcher,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractListBasedFieldEditor<Row>(document, field, pages, dispatcher, onChange), TableFieldEditor {

    override val rows by lazy { RowCollectionImpl(document, field, this, identity, onChange) }

    override val columns by lazy { ColumnCollectionImpl(this) }

    override val state = mutableLiveOf(TableState(form = null))

    private fun <T> Collection<T>.commonValue(): T? {
        if (isEmpty()) return null
        val value = first()
        return if (all { it == value }) value else null
    }

    override fun showRowForm() {
        val editor = rows.create()
        val selected = rows.selected()
        for (column in field.columns) {
            val value: Any? = when (column) {
                is TextColumn -> selected.map { it.text(column.id)?.text?.value }.commonValue() ?: column.value
                is DropdownColumn -> selected.map { it.dropdown(column.id)?.option?.value?.id }.commonValue() ?: column.value
                is ImageColumn -> column.value.map { it.toMap() }.toMutableList()
                else -> null
            }
            editor.row.cells[column.id] = value
        }
        state.value = state.value.copy(form = editor)
    }

    override fun hideRowForm() {
        state.value = state.value.copy(form = null)
    }

    override fun submit() {
        val form = state.value.form ?: return hideRowForm()
        rows.selected().forEach(form::copyInto)
        hideRowForm()
    }
}