package joyfill.editors.internal

import joyfill.Document
import joyfill.EventDispatcher
import joyfill.collections.PageCollection
import joyfill.editors.BlockFieldEditor
import joyfill.fields.BlockField
import joyfill.fields.Field
import joyfill.fields.RichTextField
import joyfill.validation.FieldValid
import joyfill.validation.FieldValidity

@PublishedApi
internal open class BlockFieldEditorImpl(
    document: Document,
    override val field: BlockField,
    pages: PageCollection,
    dispatcher: EventDispatcher,
) : AnyFieldEditor<BlockField>(document, field, pages, dispatcher, null), BlockFieldEditor {
    override fun validate() = FieldValid(field, emptyList())
}