package joyfill.editors.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.collections.PageCollection
import joyfill.conditions.AndEval
import joyfill.conditions.ConditionDefinition
import joyfill.conditions.Contains
import joyfill.conditions.Empty
import joyfill.conditions.Equals
import joyfill.conditions.Filled
import joyfill.conditions.GreaterThan
import joyfill.conditions.HideAction
import joyfill.conditions.LessThan
import joyfill.conditions.NotEquals
import joyfill.conditions.OrEval
import joyfill.conditions.ShowAction
import joyfill.conditions.UnknownConditionOperator
import joyfill.conditions.UnknownEval
import joyfill.editors.ValueBasedFieldEditor
import joyfill.fields.ValueBasedField
import joyfill.validation.FieldInvalid
import joyfill.validation.FieldValid
import joyfill.validation.FieldValidity

@PublishedApi
internal abstract class AbstractValueBasedFieldEditor<V, F : ValueBasedField<V>>(
    document: Document,
    override val field: F,
    onChange: ((ChangeEvent) -> Unit)?,
    dispatcher: EventDispatcher,
    pages: PageCollection
) : AnyFieldEditor<F>(document, field, pages, dispatcher, onChange), ValueBasedFieldEditor<V> {

    override var value: V?
        get() = this.field.value
        set(value) {
            this.field.value = value
            resolveConditions()
            notifyChange(value)
        }

    override fun validate(): FieldValidity {
        if (hidden.value || !field.required) return FieldValid(field, emptyList())
        if (field.required && (value == null || value == "")) return FieldInvalid(field, listOf("Field ${field.title} is required"))
        return FieldValid(field, emptyList())
    }
}