/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.run;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class JoobyRunOptions {
    private String projectName;
    private String mainClass;
    private List<String> restartExtensions = Arrays.asList("conf", "properties", "class");
    private List<String> compileExtensions = Arrays.asList("java", "kt");
    private Integer port = null;
    private Path basedir;
    private Long waitTimeBeforeRestart = 500L;
    private boolean useSingleClassLoader;
    private static final long DEFAULT_WAIT_TIME_BEFORE_RESTART = 500L;
    static final long INITIAL_DELAY_BEFORE_FIRST_RESTART = 5000L;

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean isUseSingleClassLoader() {
        return this.useSingleClassLoader;
    }

    public void setUseSingleClassLoader(boolean useSingleClassLoader) {
        this.useSingleClassLoader = useSingleClassLoader;
    }

    public Long getWaitTimeBeforeRestart() {
        return this.waitTimeBeforeRestart;
    }

    public void setWaitTimeBeforeRestart(Long waitTimeBeforeRestart) {
        if (waitTimeBeforeRestart != null) {
            this.waitTimeBeforeRestart = waitTimeBeforeRestart;
        }
    }

    public List<String> getRestartExtensions() {
        return this.restartExtensions;
    }

    public void setRestartExtensions(List<String> restartExtensions) {
        if (restartExtensions != null && !restartExtensions.isEmpty()) {
            this.restartExtensions = restartExtensions;
        }
    }

    public List<String> getCompileExtensions() {
        return this.compileExtensions;
    }

    public void setCompileExtensions(List<String> compileExtensions) {
        if (compileExtensions != null && !compileExtensions.isEmpty()) {
            this.compileExtensions = compileExtensions;
        }
    }

    public boolean isCompileExtension(Path path) {
        return this.containsExtension(this.compileExtensions, path);
    }

    public boolean isClass(Path path) {
        return this.containsExtension(List.of("class"), path);
    }

    public boolean isRestartExtension(Path path) {
        return this.containsExtension(this.restartExtensions, path);
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public void setBasedir(Path basedir) {
        this.basedir = basedir;
    }

    private boolean containsExtension(List<String> extensions, Path path) {
        String filename = path.getFileName().toString();
        return extensions.stream().anyMatch(ext -> filename.endsWith("." + ext));
    }

    public String toString() {
        return "{projectName='" + this.projectName + "', mainClass='" + this.mainClass + "', restartExtensions=" + String.valueOf(this.restartExtensions) + ", compileExtensions=" + String.valueOf(this.compileExtensions) + ", port=" + this.port + "}";
    }
}

