/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.kafka;

import io.jooby.Environment;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;

final class KafkaHelper {
    private KafkaHelper() {
    }

    public static void install(Jooby application, String key, Function<Properties, AutoCloseable> factory) {
        Environment environment = application.getEnvironment();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)environment.getProperties(key, null));
        AutoCloseable service = factory.apply(properties);
        ServiceRegistry registry = application.getServices();
        application.onStop(service::close);
        Class<?> serviceType = service.getClass();
        registry.putIfAbsent(serviceType, (Object)service);
        registry.put(ServiceKey.key(serviceType, (String)key), (Object)service);
    }
}

