/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jdbi;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.internal.jdbi.HandleProvider;
import io.jooby.internal.jdbi.SqlObjectProvider;
import jakarta.inject.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.sql.DataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class JdbiModule
implements Extension {
    private String name;
    private Function<DataSource, Jdbi> factory;
    private List<Class> sqlObjects = Collections.emptyList();

    public JdbiModule() {
        this("db");
    }

    public JdbiModule(@NonNull String name) {
        this.name = name;
        this.factory = null;
    }

    public JdbiModule(@NonNull Function<DataSource, Jdbi> factory) {
        this("db", factory);
    }

    public JdbiModule(@NonNull String name, @NonNull Function<DataSource, Jdbi> factory) {
        this(name);
        this.factory = factory;
    }

    @NonNull
    public JdbiModule sqlObjects(Class ... sqlObjects) {
        this.sqlObjects = Arrays.asList(sqlObjects);
        return this;
    }

    public void install(@NonNull Jooby application) throws Exception {
        Jdbi jdbi;
        ServiceRegistry registry = application.getServices();
        if (this.factory != null) {
            jdbi = this.factory.apply(this.findDataSource(registry));
        } else {
            jdbi = Jdbi.create((DataSource)this.findDataSource(registry));
            jdbi.installPlugins();
        }
        registry.putIfAbsent(ServiceKey.key(Jdbi.class), (Object)jdbi);
        registry.put(ServiceKey.key(Jdbi.class, (String)this.name), (Object)jdbi);
        HandleProvider provider = new HandleProvider(jdbi);
        registry.putIfAbsent(ServiceKey.key(Handle.class), (Provider)provider);
        registry.put(ServiceKey.key(Handle.class, (String)this.name), (Provider)provider);
        for (Class sqlObject : this.sqlObjects) {
            registry.put(sqlObject, (Provider)new SqlObjectProvider(jdbi, sqlObject));
        }
    }

    private DataSource findDataSource(@NonNull ServiceRegistry registry) {
        DataSource dataSource = (DataSource)registry.getOrNull(ServiceKey.key(DataSource.class, (String)this.name));
        if (dataSource == null) {
            dataSource = (DataSource)registry.require(DataSource.class);
        }
        return dataSource;
    }
}

