/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jdbi;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.RequestScope;
import io.jooby.Route;
import io.jooby.ServiceKey;
import java.io.Serializable;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class TransactionalRequest
implements Route.Filter {
    private ServiceKey<Jdbi> key;
    private boolean enabledByDefault = true;

    public TransactionalRequest(@NonNull String name) {
        this.key = ServiceKey.key(Jdbi.class, (String)name);
    }

    public TransactionalRequest() {
        this.key = ServiceKey.key(Jdbi.class);
    }

    public TransactionalRequest enabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            if (ctx.getRoute().isTransactional(this.enabledByDefault)) {
                Jdbi jdbi = (Jdbi)ctx.require(this.key);
                try {
                    Object object;
                    block10: {
                        Handle handle = jdbi.open();
                        try {
                            RequestScope.bind((Object)jdbi, (Object)handle);
                            object = handle.inTransaction(h -> next.apply(ctx));
                            if (handle == null) break block10;
                        }
                        catch (Throwable throwable) {
                            if (handle != null) {
                                try {
                                    handle.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        handle.close();
                    }
                    return object;
                }
                finally {
                    RequestScope.unbind((Object)jdbi);
                }
            }
            return next.apply(ctx);
        };
    }
}

