/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.hibernate.validator;

import io.jooby.Registry;
import io.jooby.exception.RegistryException;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Registry registry;

    public RegistryConstraintValidatorFactory(Registry registry) {
        this.registry = registry;
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        try {
            return (T)((ConstraintValidator)this.registry.require(key));
        }
        catch (RegistryException notfound) {
            return null;
        }
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        if (instance instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)instance;
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.log.debug("Failed to release constraint", (Throwable)e);
            }
        }
    }
}

