/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.hibernate.validator;

import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.internal.hibernate.validator.RegistryConstraintValidatorFactory;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import java.util.Deque;
import java.util.LinkedList;
import org.slf4j.Logger;

public class CompositeConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final Logger log;
    private final ConstraintValidatorFactory defaultFactory;
    private final Deque<ConstraintValidatorFactory> factories = new LinkedList<ConstraintValidatorFactory>();

    public CompositeConstraintValidatorFactory(Jooby registry, ConstraintValidatorFactory defaultFactory) {
        this.log = registry.getLog();
        this.defaultFactory = defaultFactory;
        this.factories.addLast(new RegistryConstraintValidatorFactory((Registry)registry));
    }

    public ConstraintValidatorFactory add(ConstraintValidatorFactory factory) {
        this.factories.addFirst(factory);
        return this;
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        if (this.isBuiltIn(key)) {
            return (T)this.defaultFactory.getInstance(key);
        }
        for (ConstraintValidatorFactory factory : this.factories) {
            ConstraintValidator instance = factory.getInstance(key);
            if (instance == null) continue;
            return (T)instance;
        }
        return (T)this.defaultFactory.getInstance(key);
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        if (this.isBuiltIn(instance.getClass())) {
            this.defaultFactory.releaseInstance(instance);
        } else if (instance instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)instance;
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.log.debug("Failed to release constraint", (Throwable)e);
            }
        }
    }

    private boolean isBuiltIn(Class<?> key) {
        String name = key.getName();
        return name.startsWith("org.hibernate.validator") || name.startsWith("jakarta.validation");
    }
}

