/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate.validator;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ErrorHandler;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceRegistry;
import io.jooby.StatusCode;
import io.jooby.hibernate.validator.ConstraintViolationHandler;
import io.jooby.internal.hibernate.validator.CompositeConstraintValidatorFactory;
import io.jooby.validation.BeanValidator;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class HibernateValidatorModule
implements Extension {
    private static final String CONFIG_ROOT_PATH = "hibernate.validator";
    private Consumer<HibernateValidatorConfiguration> configurer;
    private StatusCode statusCode = StatusCode.UNPROCESSABLE_ENTITY;
    private String title = "Validation failed";
    private boolean disableDefaultViolationHandler = false;
    private boolean logException = false;
    private List<ConstraintValidatorFactory> factories;
    private final HibernateValidatorConfiguration configuration;

    public HibernateValidatorModule(@NonNull HibernateValidatorConfiguration configuration) {
        this.configuration = configuration;
    }

    public HibernateValidatorModule() {
        this((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure());
    }

    public HibernateValidatorModule statusCode(@NonNull StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HibernateValidatorModule logException() {
        this.logException = true;
        return this;
    }

    public HibernateValidatorModule validationTitle(@NonNull String title) {
        this.title = title;
        return this;
    }

    public HibernateValidatorModule disableViolationHandler() {
        this.disableDefaultViolationHandler = true;
        return this;
    }

    public HibernateValidatorModule with(ConstraintValidatorFactory factory) {
        if (this.factories == null) {
            this.factories = new ArrayList<ConstraintValidatorFactory>();
        }
        this.factories.add(factory);
        return this;
    }

    public void install(@NonNull Jooby app) throws Exception {
        Config config = app.getConfig();
        if (config.hasPath(CONFIG_ROOT_PATH)) {
            config.getConfig(CONFIG_ROOT_PATH).root().forEach((k, v) -> this.configuration.addProperty("hibernate.validator." + k, v.unwrapped().toString()));
        }
        CompositeConstraintValidatorFactory delegateFactory = new CompositeConstraintValidatorFactory(app, this.configuration.getDefaultConstraintValidatorFactory());
        if (this.factories != null) {
            this.factories.forEach(delegateFactory::add);
            this.factories.clear();
        }
        this.configuration.constraintValidatorFactory((ConstraintValidatorFactory)delegateFactory);
        if (this.configurer != null) {
            this.configurer.accept(this.configuration);
        }
        ServiceRegistry services = app.getServices();
        try (ValidatorFactory factory = this.configuration.buildValidatorFactory();){
            Validator validator = factory.getValidator();
            services.put(Validator.class, (Object)validator);
            services.put(BeanValidator.class, (Object)new BeanValidatorImpl(validator));
            ConstraintValidatorFactory constraintValidatorFactory = factory.getConstraintValidatorFactory();
            services.put(ConstraintValidatorFactory.class, (Object)constraintValidatorFactory);
            if (!this.disableDefaultViolationHandler) {
                app.error(ConstraintViolationException.class, (ErrorHandler)new ConstraintViolationHandler(this.statusCode, this.title, this.logException, app.problemDetailsIsEnabled()));
            }
        }
    }

    static class BeanValidatorImpl
    implements BeanValidator {
        private final Validator validator;

        BeanValidatorImpl(Validator validator) {
            this.validator = validator;
        }

        public void validate(Context ctx, Object bean) throws ConstraintViolationException {
            Set violations = this.validator.validate(bean, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
    }
}

