/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.guice.GuiceRegistry;
import io.jooby.guice.JoobyModule;
import java.util.ArrayList;
import java.util.List;

public class GuiceModule
implements Extension {
    private Injector injector;
    private Module[] modules;

    public GuiceModule(@NonNull Injector injector) {
        this.injector = injector;
    }

    public GuiceModule(Module ... modules) {
        this.modules = modules;
    }

    public boolean lateinit() {
        return true;
    }

    public void install(@NonNull Jooby application) {
        if (this.injector == null) {
            Environment env = application.getEnvironment();
            ArrayList<Object> modules = new ArrayList<Object>();
            if (this.modules != null) {
                modules.addAll(List.of(this.modules));
            }
            modules.add((Object)new JoobyModule(application));
            Stage stage = env.isActive("dev", new String[]{"test"}) ? Stage.DEVELOPMENT : Stage.PRODUCTION;
            this.injector = Guice.createInjector((Stage)stage, modules);
        }
        application.registry((Registry)new GuiceRegistry(this.injector));
    }
}

