/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.camel;

import io.jooby.Registry;
import io.jooby.ServiceKey;
import io.jooby.SneakyThrows;
import io.jooby.exception.RegistryException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.impl.engine.DefaultInjector;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.support.PluginHelper;

public class JoobyInjector
implements Injector {
    private final DefaultInjector defaultInjector;
    private final Registry registry;
    private final CamelContext camel;
    private final CamelBeanPostProcessor postProcessor;

    public JoobyInjector(CamelContext camel, Registry registry) {
        this.registry = registry;
        this.camel = camel;
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)camel);
        this.defaultInjector = new DefaultInjector(camel);
    }

    public <T> T newInstance(Class<T> type) {
        return this.newInstance(type, true);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        return (T)this.defaultInjector.newInstance(type, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, Class<?> factoryClass, String factoryMethod) {
        return (T)this.defaultInjector.newInstance(type, factoryClass, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        T instance = this.require(ServiceKey.key(type));
        if (instance != null) {
            return this.postProcessBean(instance, postProcessBean);
        }
        return (T)this.defaultInjector.newInstance(type, postProcessBean);
    }

    private <T> T require(ServiceKey<T> key) {
        try {
            return (T)this.registry.require(key);
        }
        catch (RegistryException notfound) {
            return null;
        }
    }

    private <T> T postProcessBean(T bean, boolean postProcessBean) {
        CamelContextAware.trySetCamelContext(bean, (CamelContext)this.camel);
        if (postProcessBean) {
            try {
                this.postProcessor.postProcessBeforeInitialization(bean, bean.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(bean, bean.getClass().getName());
            }
            catch (Exception cause) {
                throw SneakyThrows.propagate((Throwable)cause);
            }
        }
        return bean;
    }

    public boolean supportsAutoWiring() {
        return true;
    }
}

