/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.camel;

import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.internal.camel.CamelBeans;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.camel.spi.BeanRepository;

public class JoobyBeanRepository
implements BeanRepository {
    private final ServiceRegistry registry;

    public JoobyBeanRepository(ServiceRegistry registry) {
        this.registry = registry;
    }

    public Object lookupByName(String name) {
        Provider<?> provider = this.beanByName(name);
        return provider == null ? null : provider.get();
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        return (T)this.getBean(ServiceKey.key(type, (String)name));
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        Map.Entry<ServiceKey<?>, Provider<?>> def;
        Object bean = this.getBean(ServiceKey.key(type));
        String beanName = null;
        if (bean == null && (def = this.beanByType(type)) != null) {
            bean = def.getValue().get();
            beanName = def.getKey().getName();
        }
        return bean == null ? Collections.emptyMap() : Collections.singletonMap(Optional.ofNullable(beanName).orElseGet(() -> CamelBeans.camelBeanId(type)), bean);
    }

    public <T> Set<T> findByType(Class<T> type) {
        return Optional.ofNullable(this.getBean(ServiceKey.key(type))).map(Collections::singleton).orElse(Collections.emptySet());
    }

    private <T> Object getBean(ServiceKey<T> key) {
        return this.registry.getOrNull(key);
    }

    private Provider<?> beanByName(String beanId) {
        Map.Entry<ServiceKey<?>, Provider<?>> entry = this.findBean(key -> Optional.ofNullable(key.getName()).orElseGet(() -> CamelBeans.camelBeanId(key.getRawType())).equals(beanId));
        return entry == null ? null : entry.getValue();
    }

    private Map.Entry<ServiceKey<?>, Provider<?>> beanByType(Class type) {
        return this.findBean(key -> key.getRawType().equals(type));
    }

    private Map.Entry<ServiceKey<?>, Provider<?>> findBean(Predicate<ServiceKey<?>> predicate) {
        for (Map.Entry e : this.registry.entrySet()) {
            if (!predicate.test((ServiceKey)e.getKey())) continue;
            return e;
        }
        return null;
    }
}

