/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.awssdkv2;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceRegistry;
import io.jooby.awssdkv2.ConfigCredentialsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class AwsModule
implements Extension {
    private final AwsCredentialsProvider credentialsProvider;
    private final List<Function<AwsCredentialsProvider, Object>> factoryList = new ArrayList<Function<AwsCredentialsProvider, Object>>();

    public AwsModule(@NonNull AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public AwsModule() {
        this.credentialsProvider = null;
    }

    @NonNull
    public AwsModule setup(@NonNull Function<AwsCredentialsProvider, Object> provider) {
        this.factoryList.add(provider);
        return this;
    }

    public void install(@NonNull Jooby application) throws Exception {
        Config config = application.getConfig();
        AwsCredentialsProvider credentialsProvider = Optional.ofNullable(this.credentialsProvider).orElseGet(() -> AwsModule.newCredentialsProvider(config));
        ArrayList<Object> serviceList = new ArrayList<Object>(this.factoryList.size());
        for (Function<AwsCredentialsProvider, Object> factory : this.factoryList) {
            Object object = factory.apply(credentialsProvider);
            if (object instanceof Stream) {
                Stream values = (Stream)object;
                values.forEach(serviceList::add);
                continue;
            }
            if (object instanceof Iterable) {
                Iterable values = (Iterable)object;
                values.forEach(serviceList::add);
                continue;
            }
            serviceList.add(object);
        }
        ServiceRegistry services = application.getServices();
        for (Object e : serviceList) {
            Stream.of(e.getClass(), Stream.of(e.getClass().getInterfaces()).findFirst().orElse(null)).filter(Objects::nonNull).forEach(serviceType -> services.putIfAbsent(serviceType, service));
        }
        serviceList.stream().filter(SdkAutoCloseable.class::isInstance).map(SdkAutoCloseable.class::cast).forEach(arg_0 -> ((Jooby)application).onStop(arg_0));
        serviceList.clear();
        this.factoryList.clear();
    }

    @NonNull
    public static AwsCredentialsProvider newCredentialsProvider(@NonNull Config config) {
        return AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{DefaultCredentialsProvider.create(), new ConfigCredentialsProvider(config)});
    }
}

