/*
 * Decompiled with CFR 0.152.
 */
package io.joern.scanners.c;

import flatgraph.traversal.GenericSteps$;
import io.joern.console.CodeExamples$;
import io.joern.console.Query;
import io.joern.console.Query$;
import io.joern.console.QueryBundle;
import io.joern.console.TraversalWithStrRep$;
import io.joern.console.q;
import io.joern.scanners.Crew$;
import io.joern.scanners.QueryTags$;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyOrder$;
import io.shiftleft.semanticcpg.language.ICallResolver;
import io.shiftleft.semanticcpg.language.NoResolve$;
import io.shiftleft.semanticcpg.language.callgraphextension.MethodTraversal$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.language.types.expressions.CallTraversal$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.AstNodeTraversal$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.ModuleSerializationProxy;

public final class DangerousFunctions$
implements QueryBundle,
Serializable {
    private static final ICallResolver resolver;
    public static final DangerousFunctions$ MODULE$;

    private DangerousFunctions$() {
    }

    static {
        MODULE$ = new DangerousFunctions$();
        resolver = NoResolve$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DangerousFunctions$.class);
    }

    public ICallResolver resolver() {
        return resolver;
    }

    @q
    public Query getsUsed() {
        return Query$.MODULE$.make("call-to-gets", Crew$.MODULE$.suchakra(), "Dangerous function gets() used", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid `gets` function as it can lead to reads beyond buffer\n        | boundary and cause\n        | buffer overflows. Some secure alternatives are `fgets` and `gets_s`.\n        |")), 8.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)gets")), MODULE$.resolver()), "{ cpg =>\n        cpg.method(\"(?i)gets\").callIn\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)new .colon.colon((Object)QueryTags$.MODULE$.default(), (List)Nil$.MODULE$)), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_gets() {\n          |  char str[DST_BUFFER_SIZE];\n          |  gets(str);\n          |  printf(\"%s\", str);\n          |  return 0;\n          |}\n          |\n          |")), (List)Nil$.MODULE$), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int secure_gets() {\n          |  FILE *fp;\n          |  fp = fopen(\"file.txt\" , \"r\");\n          |  char str[DST_BUFFER_SIZE];\n          |  fgets(str, DST_BUFFER_SIZE, fp);\n          |  printf(\"%s\", str);\n          |  return 0;\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    @q
    public Query argvUsedInPrintf() {
        return Query$.MODULE$.make("format-controlled-printf", Crew$.MODULE$.suchakra(), "Non-constant format string passed to printf/sprintf/vsprintf", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid user controlled format strings like \"argv\" in printf, sprintf and vsprintf \n        | functions as they can cause memory corruption. Some secure\n        | alternatives are `snprintf` and `vsnprintf`.\n        |")), 4.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> {
            Iterator iterator = package$.MODULE$.iterableToGenericSteps((IterableOnce)MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)printf")), MODULE$.resolver()));
            Iterator printfFns = GenericSteps$.MODULE$.whereNot$extension(iterator, (Function1 & Serializable)_$1 -> {
                Iterator iterator = package$.MODULE$.accessPropertyOrderTraversal((IterableOnce)CallTraversal$.MODULE$.argument$extension(package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)_$1)));
                Iterator iterator2 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)TraversalPropertyOrder$.MODULE$.order$extension(iterator, 1));
                return AstNodeTraversal$.MODULE$.isLiteral$extension(iterator2);
            });
            Iterator iterator2 = package$.MODULE$.iterableToGenericSteps((IterableOnce)MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)(sprintf|vsprintf)")), MODULE$.resolver()));
            Iterator sprintsFns = GenericSteps$.MODULE$.whereNot$extension(iterator2, (Function1 & Serializable)_$2 -> {
                Iterator iterator = package$.MODULE$.accessPropertyOrderTraversal((IterableOnce)CallTraversal$.MODULE$.argument$extension(package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)_$2)));
                Iterator iterator2 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)TraversalPropertyOrder$.MODULE$.order$extension(iterator, 2));
                return AstNodeTraversal$.MODULE$.isLiteral$extension(iterator2);
            });
            return printfFns.$plus$plus(() -> DangerousFunctions$.argvUsedInPrintf$$anonfun$1$$anonfun$1(sprintsFns));
        }, "{ cpg =>\n        val printfFns = cpg\n          .method(\"(?i)printf\")\n          .callIn\n          .whereNot(_.argument.order(1).isLiteral)\n        val sprintsFns = cpg\n          .method(\"(?i)(sprintf|vsprintf)\")\n          .callIn\n          .whereNot(_.argument.order(2).isLiteral)\n        printfFns ++ sprintsFns\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)new .colon.colon((Object)QueryTags$.MODULE$.default(), (List)Nil$.MODULE$)), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |int insecure_printf() {\n          |  printf(argv[1], 4242);\n          |\n          |}\n          |")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_sprintf() {\n          |  char buffer [BUFF_SIZE];\n          |  sprintf(buffer, argv[2], 4242);\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int secure_printf() {\n          |  printf(\"Num: %d\", 4242);\n          |}\n          |\n          |")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int secure_sprintf() {\n          |  char buffer [BUFF_SIZE];\n          |  snprintf(buffer, BUFF_SIZE, argv[2], 4242);\n          |}\n          |\n          |")), (List)Nil$.MODULE$))), Query$.MODULE$.make$default$9());
    }

    @q
    public Query scanfUsed() {
        return Query$.MODULE$.make("call-to-scanf", Crew$.MODULE$.suchakra(), "Insecure function scanf() used", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid `scanf` function as it can lead to reads beyond buffer\n        | boundary and cause buffer overflows. A secure alternative is `fgets`.\n        |")), 4.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)scanf")), MODULE$.resolver()), "{ cpg =>\n        cpg.method(\"(?i)scanf\").callIn\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)Nil$.MODULE$), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_scanf() {\n          |  char name[12];\n          |  scanf(\"%s\", name);\n          |  printf(\"Hello %s!\\n\", name);\n          |  return 0\n          |}\n          |\n          |")), (List)Nil$.MODULE$), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |void secure_fgets(char *buf, int size, FILE *stream) {\n          |    fgets(buf, size, stream);\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    @q
    public Query strcatUsed() {
        return Query$.MODULE$.make("call-to-strcat", Crew$.MODULE$.suchakra(), "Dangerous functions `strcat` or `strncat` used", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid `strcat` or `strncat` functions. These can be used insecurely\n        | causing non null-termianted strings leading to memory corruption.\n        | A secure alternative is `strcat_s`.\n        |")), 4.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)(strcat|strncat)")), MODULE$.resolver()), "{ cpg =>\n        cpg.method(\"(?i)(strcat|strncat)\").callIn\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)Nil$.MODULE$), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |void insecure_strcat(char *dest, char *src) {\n          |    strcat(dest, src);\n          |}\n          |\n          |")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_strncat() {\n          |  char buf[BUF_SIZE];\n          |  strncat(buf, another_buffer, BUF_SIZE - strlen(buf)); // remediation is (BUFF_SIZE - strlen(buf) - 1)\n          |  return 0\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |void secure_strcat_s(char *dest, rsize_t destsz, char *src) {\n          |    strcat_s(dest, destsz, src);\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    @q
    public Query strcpyUsed() {
        return Query$.MODULE$.make("call-to-strcpy", Crew$.MODULE$.suchakra(), "Dangerous functions `strcpy` or `strncpy` used", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid `strcpy` or `strncpy` function. `strcpy` does not check buffer\n        | lengths.\n        | A possible mitigation could be `strncpy` which could prevent\n        | buffer overflows but does not null-terminate strings leading to\n        | memory corruption. A secure alternative (on BSD) is `strlcpy`.\n        |")), 4.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)(strcpy|strncpy)")), MODULE$.resolver()), "{ cpg =>\n        cpg.method(\"(?i)(strcpy|strncpy)\").callIn\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)Nil$.MODULE$), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |void insecure_strcpy(char *dest, char *src) {\n          |    strcpy(dest, src);\n          |}\n          |\n          |")), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_strncpy() {\n          |  char buf[BUF_SIZE];\n          |  strncpy(buf, default_value, BUF_SIZE); // remediation is (BUFF_SIZE - 1)\n          |  return 0\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |void secure_strlcpy(char *dest, char *src, size_t size) {\n          |    strlcpy(dest, src, size);\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    @q
    public Query strtokUsed() {
        return Query$.MODULE$.make("call-to-strtok", Crew$.MODULE$.suchakra(), "Dangerous function strtok() used", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid `strtok` function as it modifies the original string in place\n        | and appends a null character after each token. This makes the\n        | original string unsafe. Suggested alternative is `strtok_r` with\n        | `saveptr`.\n        |")), 4.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)strtok")), MODULE$.resolver()), "{ cpg =>\n        cpg.method(\"(?i)strtok\").callIn\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)new .colon.colon((Object)QueryTags$.MODULE$.default(), (List)Nil$.MODULE$)), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_strtok() {\n          |  char *token;\n          |  char *path = getenv(\"PATH\");\n          |  token = strtok(path, \":\");\n          |  puts(token);\n          |  printf(\"PATH: %s\\n\", path); // original path string now has '/usr/bin\\0' now and is insecure to use\n          |  return 0;\n          |}\n          |\n          |")), (List)Nil$.MODULE$), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |void secure_strtok_r(char *src, char *delim, char **saveptr) {\n          |    strtok_r(src, delim, saveptr);\n          |}\n          |\n          |")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    @q
    public Query getwdUsed() {
        return Query$.MODULE$.make("call-to-getwd", Crew$.MODULE$.claudiu(), "Dangerous function getwd() used", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        | Avoid the `getwd` function, it does not check buffer lengths.\n        | Use `getcwd` instead, as it checks the buffer size.\n        |")), 4.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> MethodTraversal$.MODULE$.callIn$extension(package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(cpg).method("(?i)getwd")), MODULE$.resolver()), "{ cpg =>\n        cpg.method(\"(?i)getwd\").callIn\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.badfn(), (List)new .colon.colon((Object)QueryTags$.MODULE$.default(), (List)Nil$.MODULE$)), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |\n          |int insecure_getwd() {\n          |  char dir[12];\n          |  getwd(dir);\n          |  printf(\"Working directory:%s\\n\",dir);\n          |  return 0;\n          |}\n          |\n          |")), (List)Nil$.MODULE$), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |void secure_getcwd(char *buf, size_t len) {\n          |    getcwd(buf, len);\n          |}\n          |")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    private static final IterableOnce argvUsedInPrintf$$anonfun$1$$anonfun$1(Iterator sprintsFns$1) {
        return sprintsFns$1;
    }
}

