/*
 * Decompiled with CFR 0.152.
 */
package io.joern.scanners.android;

import flatgraph.traversal.GenericSteps$;
import io.joern.console.CodeExamples;
import io.joern.console.CodeExamples$;
import io.joern.console.CodeSnippet$;
import io.joern.console.MultiFileCodeExamples;
import io.joern.console.MultiFileCodeExamples$;
import io.joern.console.Query;
import io.joern.console.Query$;
import io.joern.console.QueryBundle;
import io.joern.console.TraversalWithStrRep;
import io.joern.console.TraversalWithStrRep$;
import io.joern.console.q;
import io.joern.dataflowengineoss.language.ExtendedCfgNode$;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.scanners.Crew$;
import io.joern.scanners.QueryTags$;
import io.joern.semanticcpg.utils.SecureXmlParsing$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.accessors.Accessors;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyCode$;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyContent$;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyMethodFullName$;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyName$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Misconfigurations$
implements QueryBundle,
Serializable {
    public static final Misconfigurations$ MODULE$ = new Misconfigurations$();

    private Misconfigurations$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Misconfigurations$.class);
    }

    @q
    public Query manifestXmlBackupEnabled() {
        return Query$.MODULE$.make("manifest-backup-enabled", Crew$.MODULE$.claudiu(), "Backups enabled in Android Manifest File", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Backup flag is set to true in AndroidManifest.xml which means that the application data can be retrieved via adb.\n          |")), 3.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> {
            String androidUri = "http://schemas.android.com/apk/res/android";
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterableToGenericSteps((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg).configFile().filter((Function1 & Serializable)_$1 -> Accessors.AccessPropertyName$.MODULE$.name$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyName((StoredNode)_$1)).endsWith("AndroidManifest.xml")));
            return GenericSteps$.MODULE$.where$extension(iterator, (Function1 & Serializable)config -> {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyContentTraversal((IterableOnce)config);
                return TraversalPropertyContent$.MODULE$.content$extension(iterator).flatMap((Function1 & Serializable)content -> SecureXmlParsing$.MODULE$.parseXml(content)).filter((Function1 & Serializable)_$2 -> {
                    String string = _$2.label();
                    String string2 = "manifest";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).flatMap((Function1 & Serializable)_$3 -> _$3.child()).filter((Function1 & Serializable)_$4 -> {
                    String string = _$4.label();
                    String string2 = "application";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).filter((Function1 & Serializable)node -> {
                    Option isAllowBackup = node.attribute(androidUri, "allowBackup");
                    Option option = isAllowBackup;
                    if (option instanceof Some) {
                        Seq n = (Seq)((Some)option).value();
                        String string = n.toString();
                        String string2 = "true";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return false;
                    }
                    throw new MatchError((Object)option);
                });
            });
        }, "{ cpg =>\n        import io.joern.semanticcpg.utils.SecureXmlParsing\n\n        val androidUri = \"http://schemas.android.com/apk/res/android\"\n        cpg.configFile\n          .filter(_.name.endsWith(\"AndroidManifest.xml\"))\n          .where { config =>\n            config.content\n              .flatMap(SecureXmlParsing.parseXml)\n              .filter(_.label == \"manifest\")\n              .flatMap(_.child)\n              .filter(_.label == \"application\")\n              .filter { node =>\n                val isAllowBackup = node.attribute(androidUri, \"allowBackup\")\n                isAllowBackup match {\n                  case Some(n) => n.toString == \"true\"\n                  case None    => false\n                }\n              }\n          }\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.android(), (List)new .colon.colon((Object)QueryTags$.MODULE$.misconfiguration(), (List)Nil$.MODULE$)), CodeExamples$.MODULE$.apply((List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n            |<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n            |    package=\"com.example.slimandroid\">\n            |\n            |    <application\n            |        android:allowBackup=\"true\"\n            |        android:label=\"SlimAndroid\"\n            |        android:supportsRtl=\"true\"\n            |        android:theme=\"@style/Theme.AppCompat\">\n            |        <activity\n            |            android:name=\".MainActivity\"\n            |            android:exported=\"true\">\n            |            <intent-filter>\n            |                <action android:name=\"android.intent.action.MAIN\" />\n            |                <category android:name=\"android.intent.category.LAUNCHER\" />\n            |            </intent-filter>\n            |        </activity>\n            |    </application>\n            |</manifest>")), (List)Nil$.MODULE$), (List)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n           |<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n           |    package=\"com.example.slimandroid\">\n           |\n           |    <application\n           |        android:allowBackup=\"false\"\n           |        android:label=\"SlimAndroid\"\n           |        android:supportsRtl=\"true\"\n           |        android:theme=\"@style/Theme.AppCompat\">\n           |        <activity\n           |            android:name=\".MainActivity\"\n           |            android:exported=\"true\">\n           |            <intent-filter>\n           |                <action android:name=\"android.intent.action.MAIN\" />\n           |                <category android:name=\"android.intent.category.LAUNCHER\" />\n           |            </intent-filter>\n           |        </activity>\n           |    </application>\n           |</manifest>")), (List)Nil$.MODULE$)), Query$.MODULE$.make$default$9());
    }

    @q
    public Query tapJacking() {
        String string = Crew$.MODULE$.claudiu();
        String string2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Android apps targeting API levels 22 and lower have the SYSTEM_ALERT_WINDOW permission enabled by default.\n          |This allows apps to draw overlays over other apps. Attackers can use this option to create an overlay that\n          |would essentially hijack user taps and use it to obtain sensitive user information."));
        TraversalWithStrRep traversalWithStrRep = TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> {
            Regex targetSdkVersionMatch = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^t]+targetSdk[^0-9]+(\\d+)"));
            int firstSecureSdkVersion = 23;
            return this.groovyBuildGradleFiles$1((Cpg)cpg).filter((Function1 & Serializable)gradleFile -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Accessors.AccessPropertyContent$.MODULE$.content$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyContent((StoredNode)gradleFile))), '\n'));
                return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)line -> targetSdkVersionMatch.findAllIn((CharSequence)line).matchData().exists((Function1 & Serializable)m -> m.groupCount() > 0 && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))) < firstSecureSdkVersion));
            });
        }, "{ cpg =>\n        def groovyBuildGradleFiles = cpg.configFile.name(\".*build.gradle\")\n        val targetSdkVersionMatch  = \"\"\"^[^t]+targetSdk[^0-9]+(\\d+)\"\"\".r\n        val firstSecureSdkVersion  = 23\n        groovyBuildGradleFiles.filter { gradleFile =>\n          gradleFile.content\n            .split('\\n')\n            .exists { line =>\n              targetSdkVersionMatch\n                .findAllIn(line)\n                .matchData\n                .exists { m =>\n                  m.groupCount > 0 && m.group(1).toInt < firstSecureSdkVersion\n                }\n            }\n        }\n      }");
        List list = (List)new .colon.colon((Object)QueryTags$.MODULE$.android(), (List)new .colon.colon((Object)QueryTags$.MODULE$.misconfiguration(), (List)Nil$.MODULE$));
        MultiFileCodeExamples multiFileCodeExamples = MultiFileCodeExamples$.MODULE$.apply((List)new .colon.colon((Object)((List)new .colon.colon((Object)CodeSnippet$.MODULE$.apply("fun main() = println(0xbadf00d)", "SomeActivity.kt"), (List)new .colon.colon((Object)CodeSnippet$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |plugins {\n              |    id 'com.android.application'\n              |    id 'kotlin-android'\n              |}\n              |\n              |android {\n              |    compileSdk 22\n              |    defaultConfig {\n              |        applicationId \"com.example.slimandroid\"\n              |        minSdk 22\n              |        targetSdk 22\n              |        versionCode 1\n              |        versionName \"1.0\"\n              |    }\n              |}\n              |")), "build.gradle"), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), (List)new .colon.colon((Object)((List)new .colon.colon((Object)CodeSnippet$.MODULE$.apply("fun main() = println(0xbadf00d)", "SomeActivity.kt"), (List)new .colon.colon((Object)CodeSnippet$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |plugins {\n                |    id 'com.android.application'\n                |    id 'kotlin-android'\n                |}\n                |\n                |android {\n                |    compileSdk 23\n                |    defaultConfig {\n                |        applicationId \"com.example.slimandroid\"\n                |        minSdk 23\n                |        targetSdk 23\n                |        versionCode 1\n                |        versionName \"1.0\"\n                |    }\n                |}\n                |")), "build.gradle"), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
        CodeExamples codeExamples = Query$.MODULE$.make$default$8();
        return Query$.MODULE$.make("tap-jacking", string, "Tap Jacking: target SDK <23 specified in `build.gradle` ", string2, 6.0, traversalWithStrRep, list, codeExamples, multiFileCodeExamples);
    }

    @q
    public Query vulnerablePRNGOnAndroidv16_18(EngineContext context) {
        return Query$.MODULE$.make("vuln-prng-android-v16_18", Crew$.MODULE$.dave(), "Vulnerable underlying PRNG used on currently set version of Android", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |The underlying PRNG is vulnerable on Android v16-18. If the application is implemented by utilizing\n          |org.webkit package and a key exchange scheme is RSA, the PreMasterSecret of the first SSL session\n          |can be recovered using the restored PRNG states.\n          |\n          |For more information, see \"Predictability of Android OpenSSL's Pseudo random number generator\" by S.H. Kim \n          |et. al.\n          |")), 6.0, TraversalWithStrRep$.MODULE$.apply((Function1 & Serializable)cpg -> {
            Regex targetSdkVersionMatch = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^t]+minSdk[^0-9]+(\\d+)"));
            int insecureSdkVersionMin = 16;
            int insecureSdkVersionMax = 18;
            if ((this.defaultSecRand$1((Cpg)cpg).nonEmpty() || ExtendedCfgNode$.MODULE$.reachableBy$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$1((Cpg)cpg)), (IterableOnce)this.source$1((Cpg)cpg), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), context).nonEmpty()) && this.satisfiesConfig$1(targetSdkVersionMatch, insecureSdkVersionMin, insecureSdkVersionMax, (Cpg)cpg).nonEmpty()) {
                return this.satisfiesConfig$1(targetSdkVersionMatch, insecureSdkVersionMin, insecureSdkVersionMax, (Cpg)cpg);
            }
            return package$.MODULE$.Iterator().empty();
        }, "{ cpg =>\n        def groovyBuildGradleFiles = cpg.configFile.name(\".*build.gradle\")\n\n        val targetSdkVersionMatch = \"\"\"^[^t]+minSdk[^0-9]+(\\d+)\"\"\".r\n        val insecureSdkVersionMin = 16\n        val insecureSdkVersionMax = 18\n        def satisfiesConfig = groovyBuildGradleFiles.filter { gradleFile =>\n          gradleFile.content\n            .split('\\n')\n            .exists { line =>\n              targetSdkVersionMatch\n                .findAllIn(line)\n                .matchData\n                .exists { m =>\n                  m.groupCount > 0 &&\n                  m.group(1).toInt >= insecureSdkVersionMin\n                  m.group(1).toInt <= insecureSdkVersionMax\n                }\n            }\n        }\n\n        def source         = cpg.literal(\"\\\".*PRNG.*\\\"\")\n        def sink           = cpg.call.code(\".*SecureRandom.getInstance.*\")\n        def defaultSecRand = cpg.call.methodFullNameExact(\"java.security.SecureRandom.<init>:void()\")\n        if (\n          (defaultSecRand.nonEmpty || sink.reachableBy(source).nonEmpty) &&\n          satisfiesConfig.nonEmpty\n        )\n          satisfiesConfig\n        else\n          Iterator.empty\n      }"), (List)new .colon.colon((Object)QueryTags$.MODULE$.android(), (List)new .colon.colon((Object)QueryTags$.MODULE$.cryptography(), (List)new .colon.colon((Object)QueryTags$.MODULE$.misconfiguration(), (List)Nil$.MODULE$))), Query$.MODULE$.make$default$8(), Query$.MODULE$.make$default$9());
    }

    private final Iterator groovyBuildGradleFiles$1(Cpg cpg$1) {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyNameTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg$1).configFile());
        return TraversalPropertyName$.MODULE$.name$extension(iterator, ".*build.gradle");
    }

    private final Iterator groovyBuildGradleFiles$2(Cpg cpg$2) {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyNameTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg$2).configFile());
        return TraversalPropertyName$.MODULE$.name$extension(iterator, ".*build.gradle");
    }

    private final Iterator satisfiesConfig$1(Regex targetSdkVersionMatch$3, int insecureSdkVersionMin$1, int insecureSdkVersionMax$1, Cpg cpg$3) {
        return this.groovyBuildGradleFiles$2(cpg$3).filter((Function1 & Serializable)gradleFile -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Accessors.AccessPropertyContent$.MODULE$.content$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyContent((StoredNode)gradleFile))), '\n'));
            return ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)line -> targetSdkVersionMatch$3.findAllIn((CharSequence)line).matchData().exists((Function1 & Serializable)m -> {
                boolean bl = m.groupCount() > 0 && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))) >= insecureSdkVersionMin$1;
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))) <= insecureSdkVersionMax$1;
            }));
        });
    }

    private final Iterator source$1(Cpg cpg$4) {
        return io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg$4).literal("\".*PRNG.*\"");
    }

    private final Iterator sink$1(Cpg cpg$5) {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyCodeTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg$5).call());
        return TraversalPropertyCode$.MODULE$.code$extension(iterator, ".*SecureRandom.getInstance.*");
    }

    private final Iterator defaultSecRand$1(Cpg cpg$6) {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyMethodFullNameTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg$6).call());
        return TraversalPropertyMethodFullName$.MODULE$.methodFullNameExact$extension(iterator, "java.security.SecureRandom.<init>:void()");
    }
}

