/*
 * Decompiled with CFR 0.152.
 */
package io.joern.scanners.java;

import io.joern.console.Query;
import io.joern.javasrc2cpg.testfixtures.JavaSrcTestCpg;
import io.joern.scanners.java.CryptographyMisuse$;
import io.joern.suites.JavaQueryTestSuite;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.compatible.Assertion;
import org.scalatest.wordspec.AnyWordSpecLike;
import scala.CanEqual$;
import scala.Function0;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.java8.JFunction0;

public class CryptographyMisuseTests
extends JavaQueryTestSuite<CryptographyMisuse$> {
    public CryptographyMisuseTests() {
        super(CryptographyMisuse$.MODULE$);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("the `unsafeHashAlgo` query");
        CryptographyMisuseTests AnyWordSpecLike_this = (CryptographyMisuseTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 7);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerBranch(WordSpecStringWrapper_this.inline$string(), (Option)Some$.MODULE$.apply((Object)"when"), "when", "when", 4, -2, position, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.f$proxy3$1());
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("the `lowIterationPbeKey` query");
        CryptographyMisuseTests AnyWordSpecLike_this2 = (CryptographyMisuseTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerBranch(WordSpecStringWrapper_this2.inline$string(), (Option)Some$.MODULE$.apply((Object)"when"), "when", "when", 4, -2, position2, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.f$proxy6$1());
    }

    private final Assertion f$proxy1$1() {
        JavaSrcTestCpg cpg = (JavaSrcTestCpg)this.code("import java.lang.CloneNotSupportedException;\nimport java.security.DigestException;\nimport java.security.MessageDigest;\n\npublic class Foo {\n public static void main(String[] args) {\n   String algo = \"MD5\";\n   MessageDigest md = MessageDigest.getInstance(algo);\n\n   try {\n     md.update(\"Hello, world!\");\n     MessageDigest tc1 = md.clone();\n     byte[] toChapter1Digest = tc1.digest();\n   } catch (CloneNotSupportedException cnse) {\n     throw new DigestException(\"couldn't make digest of partial content\");\n   }\n }\n}\n");
        Query query = ((CryptographyMisuse$)this.queryBundle()).unsafeHashAlgo(this.context());
        List<String> results = this.findMatchingLiterals((Cpg)cpg, query);
        return this.shouldBe(results, Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30), Prettifier$.MODULE$.default(), new .colon.colon((Object)"\"MD5\"", (List)Nil$.MODULE$), CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString()));
    }

    private final Assertion f$proxy2$1() {
        JavaSrcTestCpg cpg = (JavaSrcTestCpg)this.code("import java.lang.CloneNotSupportedException;\nimport java.security.DigestException;\nimport java.security.MessageDigest;\n\npublic class Foo {\n public static void main(String[] args) {\n   String algo = \"SHA256\";\n   MessageDigest md = MessageDigest.getInstance(algo);\n\n   try {\n     md.update(\"Hello, world!\");\n     MessageDigest tc1 = md.clone();\n     byte[] toChapter1Digest = tc1.digest();\n   } catch (CloneNotSupportedException cnse) {\n     throw new DigestException(\"couldn't make digest of partial content\");\n   }\n }\n}\n");
        Query query = ((CryptographyMisuse$)this.queryBundle()).unsafeHashAlgo(this.context());
        List<String> results = this.findMatchingLiterals((Cpg)cpg, query);
        return this.shouldBe(results, Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55), Prettifier$.MODULE$.default(), Nil$.MODULE$, CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString()));
    }

    private final void f$proxy3$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("find the use of the MD5 hash algorithm");
        CryptographyMisuseTests AnyWordSpecLike_this = (CryptographyMisuseTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 8);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy1$1(), position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("ignore the use of the SHA256 hash algorithm");
        CryptographyMisuseTests AnyWordSpecLike_this2 = (CryptographyMisuseTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy2$1(), position2);
    }

    private final Assertion f$proxy4$1() {
        JavaSrcTestCpg cpg = (JavaSrcTestCpg)this.code("import javax.crypto.spec.*;\nimport javax.crypto.*;\n\npublic class Foo {\n    public static void main(String[] args) {\n        var iterations = 30;\n        SecretKeyFactory factory = SecretKeyFactory.getInstance(\"PBKDF2WithHmacSHA512\");\n        SecretKey key            = factory.generateSecret( new PBEKeySpec(password.toCharArray(), salt, iterations, keyLength) );\n    }\n}\n");
        Query query = ((CryptographyMisuse$)this.queryBundle()).lowIterationPbeKey(this.context());
        List<String> results = this.findMatchingLiterals((Cpg)cpg, query);
        return this.shouldBe(results, Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74), Prettifier$.MODULE$.default(), new .colon.colon((Object)"30", (List)Nil$.MODULE$), CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString()));
    }

    private final Assertion f$proxy5$1() {
        JavaSrcTestCpg cpg = (JavaSrcTestCpg)this.code("import javax.crypto.spec.*;\nimport javax.crypto.*;\n\npublic class Foo {\n    public static void main(String[] args) {\n        var iterations = 5000;\n        SecretKeyFactory factory = SecretKeyFactory.getInstance(\"PBKDF2WithHmacSHA512\");\n        SecretKey key            = factory.generateSecret( new PBEKeySpec(password.toCharArray(), salt, iterations, keyLength) );\n    }\n}\n");
        Query query = ((CryptographyMisuse$)this.queryBundle()).lowIterationPbeKey(this.context());
        List<String> results = this.findMatchingLiterals((Cpg)cpg, query);
        return this.shouldBe(results, Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91), Prettifier$.MODULE$.default(), Nil$.MODULE$, CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString()));
    }

    private final void f$proxy6$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("find low number of iterations given to PBEKey constructor");
        CryptographyMisuseTests AnyWordSpecLike_this = (CryptographyMisuseTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy4$1(), position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("ignore sufficiently high number of iterations given to PBEKey constructor");
        CryptographyMisuseTests AnyWordSpecLike_this2 = (CryptographyMisuseTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("CryptographyMisuseTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy5$1(), position2);
    }
}

