/*
 * Decompiled with CFR 0.152.
 */
package io.joern.scanners.android;

import io.joern.console.CodeSnippet;
import io.joern.console.Query;
import io.joern.kotlin2cpg.testfixtures.KotlinTestCpg;
import io.joern.scanners.android.Misconfigurations$;
import io.joern.suites.AndroidQueryTestSuite;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.compatible.Assertion;
import org.scalatest.wordspec.AnyWordSpecLike;
import scala.CanEqual$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class MisconfigurationsTests
extends AndroidQueryTestSuite<Misconfigurations$> {
    public MisconfigurationsTests() {
        super(Misconfigurations$.MODULE$);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("the `manifestXmlBackupEnabled` query");
        MisconfigurationsTests AnyWordSpecLike_this = (MisconfigurationsTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 7);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerBranch(WordSpecStringWrapper_this.inline$string(), (Option)Some$.MODULE$.apply((Object)"when"), "when", "when", 4, -2, position, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.f$proxy6$1());
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("the `tapJacking` query");
        MisconfigurationsTests AnyWordSpecLike_this2 = (MisconfigurationsTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerBranch(WordSpecStringWrapper_this2.inline$string(), (Option)Some$.MODULE$.apply((Object)"when"), "when", "when", 4, -2, position2, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.f$proxy12$1());
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("the `vulnerablePRNGOnAndroidv16_18` query");
        MisconfigurationsTests AnyWordSpecLike_this3 = (MisconfigurationsTests)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerBranch(WordSpecStringWrapper_this3.inline$string(), (Option)Some$.MODULE$.apply((Object)"when"), "when", "when", 4, -2, position3, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.f$proxy18$1());
    }

    private final Assertion f$proxy1$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeAndroidXml(true), "AndroidManifest.xml");
        Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 13), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AndroidManifest.xml"})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualString()));
    }

    private final Assertion f$proxy2$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeAndroidXml(false), "AndroidManifest.xml");
        Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 20), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final Assertion f$proxy3$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeAndroidXml(false), "NOPNOPNOPNOPNOPNOP.xml");
        Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final Assertion f$proxy4$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode("", "AndroidManifest.xml");
        Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final Assertion f$proxy5$1() {
        String invalidXml = "\n<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n <!ENTITY lol \"lol\">\n <!ELEMENT lolz (#PCDATA)>\n <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\n <UNFINISHED_BILLION_LAUGHS\n<lolz>&lol2;</lolz>\n";
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(invalidXml, "AndroidManifest.xml");
        Query query = ((Misconfigurations$)this.queryBundle()).manifestXmlBackupEnabled();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final void f$proxy6$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("should match a config file when `allowBackup` is set to `true`");
        MisconfigurationsTests AnyWordSpecLike_this = (MisconfigurationsTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 9);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy1$1(), position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("should not match a config file when `allowBackup` is set to `false`");
        MisconfigurationsTests AnyWordSpecLike_this2 = (MisconfigurationsTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 16);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy2$1(), position2);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("should not match anything when there is no file named `AndroidManifest.xml` in the cpg");
        MisconfigurationsTests AnyWordSpecLike_this3 = (MisconfigurationsTests)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 23);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this3.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy3$1(), position3);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this4 = this.convertToWordSpecStringWrapper("should not match anything when the file named `AndroidManifest.xml` is empty");
        MisconfigurationsTests AnyWordSpecLike_this4 = (MisconfigurationsTests)WordSpecStringWrapper_this4.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position4 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30);
        AnyWordSpecLike_this4.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this4.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy4$1(), position4);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this5 = this.convertToWordSpecStringWrapper("should not match anything when the file named `AndroidManifest.xml` contains invalid XML");
        MisconfigurationsTests AnyWordSpecLike_this5 = (MisconfigurationsTests)WordSpecStringWrapper_this5.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position5 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37);
        AnyWordSpecLike_this5.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this5.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy5$1(), position5);
    }

    private final void f$proxy7$1() {
        Query q = ((Misconfigurations$)this.queryBundle()).tapJacking();
        q.multiFileCodeExamples().positive().filter((Function1 & Serializable)_$1 -> _$1.nonEmpty()).foreach((Function1 & Serializable)codeExample -> {
            CodeSnippet first = (CodeSnippet)codeExample.head();
            KotlinTestCpg cpg = (KotlinTestCpg)this.code(first.content(), first.filename());
            KotlinTestCpg finalCpg = (KotlinTestCpg)codeExample.drop(1).foldLeft((Object)cpg, (Function2 & Serializable)(foldCpg, example) -> (KotlinTestCpg)foldCpg.moreCode(example.content(), example.filename()));
            return this.shouldBe(this.findMatchingConfigFiles((Cpg)finalCpg, q), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualString()));
        });
    }

    private final void f$proxy8$1() {
        Query q = ((Misconfigurations$)this.queryBundle()).tapJacking();
        q.multiFileCodeExamples().negative().filter((Function1 & Serializable)_$2 -> _$2.nonEmpty()).foreach((Function1 & Serializable)codeExample -> {
            CodeSnippet first = (CodeSnippet)codeExample.head();
            KotlinTestCpg cpg = (KotlinTestCpg)this.code(first.content(), first.filename());
            KotlinTestCpg finalCpg = (KotlinTestCpg)codeExample.drop(1).foldLeft((Object)cpg, (Function2 & Serializable)(foldCpg, example) -> (KotlinTestCpg)foldCpg.moreCode(example.content(), example.filename()));
            return this.shouldBe(this.findMatchingConfigFiles((Cpg)finalCpg, q), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
        });
    }

    private final Assertion f$proxy9$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeBuildGradle(22, this.makeBuildGradle$default$2()), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).tapJacking();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualString()));
    }

    private final Assertion f$proxy10$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), this.makeBuildGradle$default$2()), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).tapJacking();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final Assertion f$proxy11$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("fun main() = println(0xbadf00d)").moreCode("", "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).tapJacking();
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final void f$proxy12$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("should match on all multi-file positive examples");
        MisconfigurationsTests AnyWordSpecLike_this = (MisconfigurationsTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> {
            this.f$proxy7$1();
            return BoxedUnit.UNIT;
        }, position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("should not on all multi-file negative examples");
        MisconfigurationsTests AnyWordSpecLike_this2 = (MisconfigurationsTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> {
            this.f$proxy8$1();
            return BoxedUnit.UNIT;
        }, position2);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("should match a CONFIG_FILE node when `targetSdkVersion` is set to `22`");
        MisconfigurationsTests AnyWordSpecLike_this3 = (MisconfigurationsTests)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this3.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy9$1(), position3);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this4 = this.convertToWordSpecStringWrapper("should not match a CONFIG_FILE when `targetSdkVersion` is set to `23`");
        MisconfigurationsTests AnyWordSpecLike_this4 = (MisconfigurationsTests)WordSpecStringWrapper_this4.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position4 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89);
        AnyWordSpecLike_this4.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this4.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy10$1(), position4);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this5 = this.convertToWordSpecStringWrapper("should not match anything when the file named `build.gradle` is empty");
        MisconfigurationsTests AnyWordSpecLike_this5 = (MisconfigurationsTests)WordSpecStringWrapper_this5.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position5 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96);
        AnyWordSpecLike_this5.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this5.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy11$1(), position5);
    }

    private final Assertion f$proxy13$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("import java.security.SecureRandom\n\nfun main() {\n    SecureRandom random = new SecureRandom()\n}\n").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), 16), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualString()));
    }

    private final Assertion f$proxy14$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("import java.security.SecureRandom\n\nfun main() {\n    SecureRandom random = SecureRandom.getInstance(\"NativePRNG\")\n}\n").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), 18), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"build.gradle"})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualString()));
    }

    private final Assertion f$proxy15$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("import java.security.SecureRandom\n\nfun main() {\n    SecureRandom random = SecureRandom.getInstance(\"PKCS11\")\n}\n").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), 18), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final Assertion f$proxy16$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("import java.security.SecureRandom\nfun main() = println(\"I'm okay\")").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), 17), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final Assertion f$proxy17$1() {
        KotlinTestCpg cpg = (KotlinTestCpg)this.code("import java.security.SecureRandom\n\nfun main() {\n    SecureRandom random = new SecureRandom()\n}\n").moreCode(this.makeBuildGradle(this.makeBuildGradle$default$1(), 19), "build.gradle");
        Query query = ((Misconfigurations$)this.queryBundle()).vulnerablePRNGOnAndroidv16_18(this.context());
        return this.shouldBe(this.findMatchingConfigFiles((Cpg)cpg, query), Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualAny()));
    }

    private final void f$proxy18$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("should match when the minSdk version is v16-18 and a call to SecureRandom default constructor is present");
        MisconfigurationsTests AnyWordSpecLike_this = (MisconfigurationsTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToIgnore(WordSpecStringWrapper_this.inline$string(), (List)Nil$.MODULE$, "ignore", (Function0 & Serializable)() -> this.f$proxy13$1(), position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("should match when the minSdk version is v16-18 and a call to SecureRandom.getInstance with a PRNG algorithm is set");
        MisconfigurationsTests AnyWordSpecLike_this2 = (MisconfigurationsTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToIgnore(WordSpecStringWrapper_this2.inline$string(), (List)Nil$.MODULE$, "ignore", (Function0 & Serializable)() -> this.f$proxy14$1(), position2);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("should not match when the minSdk version is v16-18 and a call to SecureRandom.getInstance with a non-PRNG algorithm is set");
        MisconfigurationsTests AnyWordSpecLike_this3 = (MisconfigurationsTests)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this3.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy15$1(), position3);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this4 = this.convertToWordSpecStringWrapper("should not match when the minSdk version is v16-18 but no call to SecureRandom is present");
        MisconfigurationsTests AnyWordSpecLike_this4 = (MisconfigurationsTests)WordSpecStringWrapper_this4.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position4 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143);
        AnyWordSpecLike_this4.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this4.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy16$1(), position4);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this5 = this.convertToWordSpecStringWrapper("should not match when the minSdk version is 18 > and a call to SecureRandom is present");
        MisconfigurationsTests AnyWordSpecLike_this5 = (MisconfigurationsTests)WordSpecStringWrapper_this5.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position5 = Position$.MODULE$.apply("MisconfigurationsTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150);
        AnyWordSpecLike_this5.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this5.inline$string(), (List)Nil$.MODULE$, "in", (Function0 & Serializable)() -> this.f$proxy17$1(), position5);
    }
}

