/*
 * Decompiled with CFR 0.152.
 */
package io.jchunk.fixed;

import io.jchunk.commons.Delimiter;
import io.jchunk.core.chunk.Chunk;
import io.jchunk.core.chunk.IChunker;
import io.jchunk.fixed.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class FixedChunker
implements IChunker {
    private static final Logger logger = Logger.getLogger(FixedChunker.class.getName());
    private static final String LONGER_THAN_THE_SPECIFIED = "Created a chunk of size %d, which is longer than the specified %d";
    private final Config config;

    public FixedChunker() {
        this(Config.defaultConfig());
    }

    public FixedChunker(Config config) {
        this.config = config;
    }

    public List<Chunk> split(String content) {
        List<String> sentences = this.splitIntoSentences(content, this.config);
        return this.mergeSentences(sentences, this.config);
    }

    public List<String> splitIntoSentences(String content, Config config) {
        String delimiter = config.getDelimiter();
        Delimiter keepDelimiter = config.getKeepDelimiter();
        if (delimiter.isEmpty()) {
            return content.chars().mapToObj(c -> String.valueOf((char)c)).toList();
        }
        return this.splitWithDelimiter(content, delimiter, keepDelimiter);
    }

    private List<String> splitWithDelimiter(String content, String delimiter, Delimiter keepDelimiter) {
        if (keepDelimiter == Delimiter.NONE) {
            return Arrays.stream(content.split(delimiter)).filter(s -> !s.isEmpty()).toList();
        }
        String withDelimiter = "((?<=%1$s)|(?=%1$s))";
        ArrayList<String> preSplits = new ArrayList<String>(List.of(content.split(String.format(withDelimiter, delimiter))));
        return keepDelimiter == Delimiter.START ? this.splitWithDelimiterStart(preSplits) : this.splitWithDelimiterEnd(preSplits);
    }

    private List<String> splitWithDelimiterStart(List<String> preSplits) {
        ArrayList<String> splits = new ArrayList<String>();
        splits.add(preSplits.getFirst());
        IntStream.range(1, preSplits.size() - 1).filter(i -> i % 2 == 1).forEach(i -> splits.add(((String)preSplits.get(i)).concat((String)preSplits.get(i + 1))));
        return splits.stream().filter(s -> !s.isEmpty()).toList();
    }

    private List<String> splitWithDelimiterEnd(List<String> preSplits) {
        ArrayList<String> splits = new ArrayList<String>();
        IntStream.range(0, preSplits.size() - 1).filter(i -> i % 2 == 0).forEach(i -> splits.add(((String)preSplits.get(i)).concat((String)preSplits.get(i + 1))));
        splits.add(preSplits.getLast());
        return splits.stream().filter(s -> !s.isEmpty()).toList();
    }

    private List<Chunk> mergeSentences(List<String> sentences, Config config) {
        String delimiter = config.getDelimiter();
        int chunkSize = config.getChunkSize();
        int chunkOverlap = config.getChunkOverlap();
        boolean trimWhitespace = config.getTrimWhitespace();
        int currentLen = 0;
        int delimiterLen = delimiter.length();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        LinkedList<String> currentChunk = new LinkedList<String>();
        AtomicInteger chunkIndex = new AtomicInteger(0);
        for (String sentence : sentences) {
            int sentenceLength = sentence.length();
            if (currentLen + sentenceLength + (currentChunk.isEmpty() ? 0 : delimiterLen) > chunkSize) {
                if (currentLen > chunkSize) {
                    String msg = String.format(LONGER_THAN_THE_SPECIFIED, currentLen, config.getChunkSize());
                    logger.warning(msg);
                }
                if (!currentChunk.isEmpty()) {
                    this.addChunk(chunks, currentChunk, delimiter, trimWhitespace, chunkIndex);
                    currentLen = this.adjustCurrentChunkForOverlap(currentChunk, currentLen, chunkOverlap, delimiterLen);
                }
            }
            currentChunk.add(sentence);
            currentLen += sentenceLength + (currentChunk.size() > 1 ? delimiterLen : 0);
        }
        if (!currentChunk.isEmpty()) {
            this.addChunk(chunks, currentChunk, delimiter, trimWhitespace, chunkIndex);
        }
        return chunks;
    }

    private void addChunk(List<Chunk> chunks, Deque<String> currentChunk, String delimiter, boolean trimWhitespace, AtomicInteger index) {
        String generatedSentence = this.joinSentences(currentChunk, delimiter, trimWhitespace);
        Chunk chunk = Chunk.of((int)index.getAndIncrement(), (String)generatedSentence);
        chunks.add(chunk);
    }

    private int adjustCurrentChunkForOverlap(Deque<String> currentChunk, int currentLen, int chunkOverlap, int delimiterLen) {
        while (currentLen > chunkOverlap && !currentChunk.isEmpty()) {
            currentLen -= currentChunk.removeFirst().length() + (currentChunk.isEmpty() ? 0 : delimiterLen);
        }
        return currentLen;
    }

    private String joinSentences(Deque<String> sentences, String delimiter, boolean trimWhitespace) {
        String generatedSentence = String.join((CharSequence)delimiter, sentences);
        return trimWhitespace ? generatedSentence.trim() : generatedSentence;
    }
}

