/*
 * Decompiled with CFR 0.152.
 */
package io.jchunk.fixed;

import io.jchunk.assertions.Assertions;
import io.jchunk.commons.Delimiter;

public class Config {
    private final int chunkSize;
    private final int chunkOverlap;
    private final String delimiter;
    private final boolean trimWhitespace;
    private final Delimiter keepDelimiter;

    private Config(int chunkSize, int chunkOverlap, String delimiter, boolean trimWhitespace, Delimiter keepDelimiter) {
        this.chunkSize = chunkSize;
        this.chunkOverlap = chunkOverlap;
        this.delimiter = delimiter;
        this.trimWhitespace = trimWhitespace;
        this.keepDelimiter = keepDelimiter;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getChunkOverlap() {
        return this.chunkOverlap;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public Delimiter getKeepDelimiter() {
        return this.keepDelimiter;
    }

    public static Config defaultConfig() {
        return Config.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int chunkSize = 1000;
        private int chunkOverlap = 100;
        private String delimiter = " ";
        private boolean trimWhitespace = true;
        private Delimiter keepDelimiter = Delimiter.NONE;

        public Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder chunkOverlap(int chunkOverlap) {
            this.chunkOverlap = chunkOverlap;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder trimWhitespace(boolean trimWhitespace) {
            this.trimWhitespace = trimWhitespace;
            return this;
        }

        public Builder keepDelimiter(Delimiter keepDelimiter) {
            this.keepDelimiter = keepDelimiter;
            return this;
        }

        public Config build() {
            Assertions.isTrue((this.chunkSize > 0 ? 1 : 0) != 0, (String)"Chunk size must be greater than 0");
            Assertions.isTrue((this.chunkOverlap >= 0 ? 1 : 0) != 0, (String)"Chunk overlap must be greater than or equal to 0");
            Assertions.isTrue((this.chunkSize > this.chunkOverlap ? 1 : 0) != 0, (String)"Chunk size must be greater than chunk overlap");
            return new Config(this.chunkSize, this.chunkOverlap, this.delimiter, this.trimWhitespace, this.keepDelimiter);
        }
    }
}

