/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.javaoperatorsdk.operator.api.config.informer.InformerEventSourceConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import io.javaoperatorsdk.operator.sample.Tomcat;
import io.javaoperatorsdk.operator.sample.TomcatSpec;
import io.javaoperatorsdk.operator.sample.TomcatStatus;
import io.javaoperatorsdk.operator.sample.Webapp;
import io.javaoperatorsdk.operator.sample.WebappSpec;
import io.javaoperatorsdk.operator.sample.WebappStatus;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class WebappReconciler
implements Reconciler<Webapp>,
Cleaner<Webapp> {
    private static final Logger log = LoggerFactory.getLogger(WebappReconciler.class);
    private final KubernetesClient kubernetesClient;

    public WebappReconciler(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public List<EventSource<?, Webapp>> prepareEventSources(EventSourceContext<Webapp> context) {
        SecondaryToPrimaryMapper webappsMatchingTomcatName = t -> context.getPrimaryCache().list(webApp -> ((WebappSpec)webApp.getSpec()).getTomcat().equals(t.getMetadata().getName())).map(ResourceID::fromResource).collect(Collectors.toSet());
        InformerEventSourceConfiguration configuration = InformerEventSourceConfiguration.from(Tomcat.class, Webapp.class).withSecondaryToPrimaryMapper(webappsMatchingTomcatName).withPrimaryToSecondaryMapper(primary -> Set.of(new ResourceID(((WebappSpec)primary.getSpec()).getTomcat(), primary.getMetadata().getNamespace()))).build();
        return List.of(new InformerEventSource(configuration, context));
    }

    public UpdateControl<Webapp> reconcile(Webapp webapp, Context<Webapp> context) {
        if (webapp.getStatus() != null && Objects.equals(((WebappSpec)webapp.getSpec()).getUrl(), ((WebappStatus)webapp.getStatus()).getDeployedArtifact())) {
            return UpdateControl.noUpdate();
        }
        Tomcat tomcat = (Tomcat)((Object)context.getSecondaryResource(Tomcat.class).orElseThrow(() -> new IllegalStateException("Cannot find Tomcat " + ((WebappSpec)webapp.getSpec()).getTomcat() + " for Webapp " + webapp.getMetadata().getName() + " in namespace " + webapp.getMetadata().getNamespace())));
        if (tomcat.getStatus() != null && Objects.equals(((TomcatSpec)tomcat.getSpec()).getReplicas(), ((TomcatStatus)tomcat.getStatus()).getReadyReplicas())) {
            log.info("Tomcat is ready and webapps not yet deployed. Commencing deployment of {} in Tomcat {}", (Object)webapp.getMetadata().getName(), (Object)tomcat.getMetadata().getName());
            String[] command = new String[]{"wget", "-O", "/data/" + ((WebappSpec)webapp.getSpec()).getContextPath() + ".war", ((WebappSpec)webapp.getSpec()).getUrl()};
            if (log.isInfoEnabled()) {
                command = new String[]{"time", "wget", "-O", "/data/" + ((WebappSpec)webapp.getSpec()).getContextPath() + ".war", ((WebappSpec)webapp.getSpec()).getUrl()};
            }
            String[] commandStatusInAllPods = this.executeCommandInAllPods(this.kubernetesClient, webapp, command);
            return UpdateControl.patchStatus((HasMetadata)this.createWebAppForStatusUpdate(webapp, commandStatusInAllPods));
        }
        log.info("WebappController invoked but Tomcat not ready yet ({}/{})", (Object)(tomcat.getStatus() != null ? ((TomcatStatus)tomcat.getStatus()).getReadyReplicas() : 0), (Object)((TomcatSpec)tomcat.getSpec()).getReplicas());
        return UpdateControl.noUpdate();
    }

    private Webapp createWebAppForStatusUpdate(Webapp actual, String[] commandStatusInAllPods) {
        Webapp webapp = new Webapp();
        webapp.setMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(actual.getMetadata().getName())).withNamespace(actual.getMetadata().getNamespace())).build());
        webapp.setStatus(new WebappStatus());
        ((WebappStatus)webapp.getStatus()).setDeployedArtifact(((WebappSpec)actual.getSpec()).getUrl());
        ((WebappStatus)webapp.getStatus()).setDeploymentStatus(commandStatusInAllPods);
        return webapp;
    }

    public DeleteControl cleanup(Webapp webapp, Context<Webapp> context) {
        String[] command = new String[]{"rm", "/data/" + ((WebappSpec)webapp.getSpec()).getContextPath() + ".war"};
        String[] commandStatusInAllPods = this.executeCommandInAllPods(this.kubernetesClient, webapp, command);
        if (webapp.getStatus() != null) {
            ((WebappStatus)webapp.getStatus()).setDeployedArtifact(null);
            ((WebappStatus)webapp.getStatus()).setDeploymentStatus(commandStatusInAllPods);
        }
        return DeleteControl.defaultDelete();
    }

    private String[] executeCommandInAllPods(KubernetesClient kubernetesClient, Webapp webapp, String[] command) {
        String[] status = new String[]{};
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)kubernetesClient.apps().deployments().inNamespace(webapp.getMetadata().getNamespace())).withName(((WebappSpec)webapp.getSpec()).getTomcat())).get();
        if (deployment != null) {
            List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(webapp.getMetadata().getNamespace())).withLabels(deployment.getSpec().getSelector().getMatchLabels())).list()).getItems();
            status = new String[pods.size()];
            for (int i = 0; i < pods.size(); ++i) {
                Pod pod = (Pod)pods.get(i);
                log.info("Executing command {} in Pod {}", (Object)String.join((CharSequence)" ", command), (Object)pod.getMetadata().getName());
                CompletableFuture<String> data = new CompletableFuture<String>();
                try (ExecWatch execWatch = this.execCmd(pod, data, command);){
                    status[i] = pod.getMetadata().getName() + ":" + data.get(30L, TimeUnit.SECONDS);
                    continue;
                }
                catch (ExecutionException e) {
                    status[i] = pod.getMetadata().getName() + ": ExecutionException - " + e.getMessage();
                    continue;
                }
                catch (InterruptedException e) {
                    status[i] = pod.getMetadata().getName() + ": InterruptedException - " + e.getMessage();
                    continue;
                }
                catch (TimeoutException e) {
                    status[i] = pod.getMetadata().getName() + ": TimeoutException - " + e.getMessage();
                }
            }
        }
        return status;
    }

    private ExecWatch execCmd(Pod pod, CompletableFuture<String> data, String ... command) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return ((ContainerResource)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).inContainer((Object)"war-downloader")).writingOutput((OutputStream)baos).writingError((OutputStream)baos).usingListener((ExecListener)new SimpleListener(data, baos)).exec(command);
    }

    static class SimpleListener
    implements ExecListener {
        private final CompletableFuture<String> data;
        private final ByteArrayOutputStream baos;
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        public SimpleListener(CompletableFuture<String> data, ByteArrayOutputStream baos) {
            this.data = data;
            this.baos = baos;
        }

        public void onOpen() {
            this.log.debug("Reading data... ");
        }

        public void onFailure(Throwable t, ExecListener.Response response) {
            this.log.debug(t.getMessage());
            this.data.completeExceptionally(t);
        }

        public void onClose(int code, String reason) {
            this.log.debug("Exit with: {} and with reason: {}", (Object)code, (Object)reason);
            this.data.complete(this.baos.toString());
        }
    }
}

