/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.Workflow;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Dependent;
import io.javaoperatorsdk.operator.sample.DeploymentDependentResource;
import io.javaoperatorsdk.operator.sample.ServiceDependentResource;
import io.javaoperatorsdk.operator.sample.Tomcat;
import io.javaoperatorsdk.operator.sample.TomcatStatus;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Workflow(dependents={@Dependent(type=DeploymentDependentResource.class), @Dependent(type=ServiceDependentResource.class)})
@ControllerConfiguration
public class TomcatReconciler
implements Reconciler<Tomcat> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public UpdateControl<Tomcat> reconcile(Tomcat tomcat, Context<Tomcat> context) {
        return context.getSecondaryResource(Deployment.class).map(deployment -> {
            Tomcat updatedTomcat = this.createTomcatForStatusUpdate(tomcat, (Deployment)deployment);
            this.log.info("Updating status of Tomcat {} in namespace {} to {} ready replicas", new Object[]{tomcat.getMetadata().getName(), tomcat.getMetadata().getNamespace(), tomcat.getStatus() == null ? 0 : ((TomcatStatus)tomcat.getStatus()).getReadyReplicas()});
            return UpdateControl.patchStatus((HasMetadata)updatedTomcat);
        }).orElseGet(UpdateControl::noUpdate);
    }

    private Tomcat createTomcatForStatusUpdate(Tomcat tomcat, Deployment deployment) {
        Tomcat res = new Tomcat();
        res.setMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(tomcat.getMetadata().getName())).withNamespace(tomcat.getMetadata().getNamespace())).build());
        DeploymentStatus deploymentStatus = Objects.requireNonNullElse(deployment.getStatus(), new DeploymentStatus());
        int readyReplicas = Objects.requireNonNullElse(deploymentStatus.getReadyReplicas(), 0);
        TomcatStatus status = new TomcatStatus();
        status.setReadyReplicas(readyReplicas);
        res.setStatus(status);
        return res;
    }
}

