/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.sample;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.informer.Informer;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import io.javaoperatorsdk.operator.sample.Tomcat;
import io.javaoperatorsdk.operator.sample.TomcatSpec;

@KubernetesDependent(informer=@Informer(labelSelector="app.kubernetes.io/managed-by=tomcat-operator"))
public class DeploymentDependentResource
extends CRUDKubernetesDependentResource<Deployment, Tomcat> {
    private static String tomcatImage(Tomcat tomcat) {
        return "tomcat:" + ((TomcatSpec)tomcat.getSpec()).getVersion();
    }

    protected Deployment desired(Tomcat tomcat, Context<Tomcat> context) {
        Deployment deployment = (Deployment)ReconcilerUtils.loadYaml(Deployment.class, ((Object)((Object)this)).getClass(), (String)"deployment.yaml");
        ObjectMeta tomcatMetadata = tomcat.getMetadata();
        String tomcatName = tomcatMetadata.getName();
        deployment = ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder(deployment).editMetadata().withName(tomcatName)).withNamespace(tomcatMetadata.getNamespace())).addToLabels("app", tomcatName)).addToLabels("app.kubernetes.io/part-of", tomcatName)).addToLabels("app.kubernetes.io/managed-by", "tomcat-operator")).endMetadata()).editSpec().editSelector().addToMatchLabels("app", tomcatName)).endSelector()).withReplicas(((TomcatSpec)tomcat.getSpec()).getReplicas())).editTemplate().editMetadata().addToLabels("app", tomcatName)).endMetadata()).editSpec().editFirstContainer().withImage(DeploymentDependentResource.tomcatImage(tomcat))).endContainer()).endSpec()).endTemplate()).endSpec()).build();
        return deployment;
    }
}

