/*
 * Decompiled with CFR 0.152.
 */
package trace4cats.stackdriver.oauth;

import cats.effect.kernel.Async;
import cats.effect.kernel.Sync$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import io.circe.Decoder$;
import java.io.Serializable;
import java.security.interfaces.RSAPrivateKey;
import java.time.Instant;
import java.util.Date;
import org.http4s.Header;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.circe.CirceEntityCodec$;
import org.http4s.client.Client;
import org.http4s.client.dsl.Http4sClientDsl;
import org.http4s.client.dsl.MethodOps$;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;
import trace4cats.stackdriver.oauth.AccessToken$;
import trace4cats.stackdriver.oauth.GoogleOAuth$FailedRequest$;
import trace4cats.stackdriver.oauth.OAuth;

public class GoogleOAuth<F>
implements OAuth<F>,
Http4sClientDsl<F> {
    private final Client<F> httpClient;
    private final Async<F> evidence$1;
    private final Logger<F> evidence$2;
    private final Algorithm algorithm;
    private final Uri googleOAuthDomain;
    private final FiniteDuration maxDuration;

    public GoogleOAuth(RSAPrivateKey key, Client<F> httpClient, Async<F> evidence$1, Logger<F> evidence$2) {
        this.httpClient = httpClient;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.algorithm = Algorithm.RSA256(null, (RSAPrivateKey)key);
        String googleOAuthDomainStr = "https://www.googleapis.com/oauth2/v4/token";
        this.googleOAuthDomain = Uri$.MODULE$.unsafeFromString("https://www.googleapis.com/oauth2/v4/token");
        this.maxDuration = new package.DurationInt(package$.MODULE$.DurationInt(1)).hour();
    }

    @Override
    public final F authenticate(String iss, String scope, Instant exp, Instant iat) {
        Object tokenF = Sync$.MODULE$.apply(this.evidence$1).delay(() -> this.$anonfun$1(iss, scope, exp, iat));
        Object request = package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(tokenF, this.evidence$1).map((Function1 & Serializable)token -> {
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"grant_type");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer");
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"assertion");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, token);
            Map form = UrlForm$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            Method method = this.http4sClientSyntaxMethod(Method$.MODULE$.POST());
            Request req = MethodOps$.MODULE$.apply$extension(method, (Object)new UrlForm(form), this.googleOAuthDomain, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), UrlForm$.MODULE$.entityEncoder(UrlForm$.MODULE$.entityEncoder$default$1()));
            return Tuple3$.MODULE$.apply(token, (Object)new UrlForm(form), (Object)req);
        }), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String token = (String)tuple3._1();
            Map form = tuple3._2() == null ? null : ((UrlForm)tuple3._2()).values();
            Request req = (Request)tuple3._3();
            return req;
        });
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.httpClient.expectOr(request, (Function1 & Serializable)resp -> package.all$.MODULE$.toFunctorOps(resp.as(this.evidence$1, CirceEntityCodec$.MODULE$.circeEntityDecoder(this.evidence$1, Decoder$.MODULE$.decodeString())), this.evidence$1).map((Function1 & Serializable)body -> GoogleOAuth$FailedRequest$.MODULE$.apply((String)body)), CirceEntityCodec$.MODULE$.circeEntityDecoder(this.evidence$1, Decoder$.MODULE$.decodeOption(AccessToken$.MODULE$.codec()))), this.evidence$1);
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)e -> package.all$.MODULE$.toFunctorOps(Logger$.MODULE$.apply(this.evidence$2).warn(e, GoogleOAuth::authenticate$$anonfun$2$$anonfun$1), this.evidence$1).as((Object)None$.MODULE$), this.evidence$1);
    }

    @Override
    public final FiniteDuration maxDuration() {
        return this.maxDuration;
    }

    private final String $anonfun$1(String iss$1, String scope$1, Instant exp$1, Instant iat$1) {
        return JWT.create().withIssuedAt(Date.from(iat$1)).withExpiresAt(Date.from(exp$1)).withAudience(new String[]{"https://www.googleapis.com/oauth2/v4/token"}).withClaim("scope", scope$1).withClaim("iss", iss$1).sign(this.algorithm);
    }

    private static final String authenticate$$anonfun$2$$anonfun$1() {
        return "Failed to retrieve JWT Access Token from Google";
    }

    public static class FailedRequest
    extends RuntimeException
    implements NoStackTrace,
    Product {
        private final String body;

        public static FailedRequest apply(String string) {
            return GoogleOAuth$FailedRequest$.MODULE$.apply(string);
        }

        public static FailedRequest fromProduct(Product product) {
            return GoogleOAuth$FailedRequest$.MODULE$.fromProduct(product);
        }

        public static FailedRequest unapply(FailedRequest failedRequest) {
            return GoogleOAuth$FailedRequest$.MODULE$.unapply(failedRequest);
        }

        public FailedRequest(String body) {
            this.body = body;
            super(new StringBuilder(30).append("Failed request, got response: ").append(body).toString());
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedRequest)) return false;
            FailedRequest failedRequest = (FailedRequest)object;
            String string = this.body();
            String string2 = failedRequest.body();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!failedRequest.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedRequest;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FailedRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "body";
        }

        public String body() {
            return this.body;
        }

        public FailedRequest copy(String body) {
            return new FailedRequest(body);
        }

        public String copy$default$1() {
            return this.body();
        }

        public String _1() {
            return this.body();
        }
    }
}

