/*
 * Decompiled with CFR 0.152.
 */
package trace4cats.stackdriver.oauth;

import cats.FlatMap;
import cats.Functor;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import io.circe.HCursor;
import io.circe.parser.package$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.regex.Pattern;
import scala.Function1;
import scala.collection.immutable.List;
import scala.runtime.ModuleSerializationProxy;
import trace4cats.stackdriver.oauth.GoogleAccountParser;
import trace4cats.stackdriver.oauth.GoogleAccountParser$JsonGoogleServiceAccount$;
import trace4cats.stackdriver.oauth.GoogleServiceAccount;
import trace4cats.stackdriver.oauth.GoogleServiceAccount$;

public final class GoogleAccountParser$
implements Serializable {
    public static final GoogleAccountParser$JsonGoogleServiceAccount$ JsonGoogleServiceAccount;
    private static final Pattern privateKeyPattern;
    public static final GoogleAccountParser$ MODULE$;

    private GoogleAccountParser$() {
    }

    static {
        MODULE$ = new GoogleAccountParser$();
        privateKeyPattern = Pattern.compile("(?m)(?s)^---*BEGIN.*---*$(.*)^---*END.*---*$.*");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GoogleAccountParser$.class);
    }

    public final <F> Object parse(Path path, Sync<F> F) {
        return package.flatMap$.MODULE$.toFlatMapOps(F.blocking(() -> this.parse$$anonfun$1(path)), F).flatMap((Function1 & Serializable)string -> package.flatMap$.MODULE$.toFlatMapOps(F.fromEither(package$.MODULE$.parse(string)), (FlatMap)F).flatMap((Function1 & Serializable)json -> package.flatMap$.MODULE$.toFlatMapOps(F.fromEither(json.as(GoogleAccountParser$JsonGoogleServiceAccount$.MODULE$.codec())), (FlatMap)F).flatMap((Function1 & Serializable)serviceAccount -> package.functor$.MODULE$.toFunctorOps(F.delay(() -> this.parse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(serviceAccount)), (Functor)F).map((Function1 & Serializable)gsa -> gsa))));
    }

    private byte[] loadPem(String pem) {
        String encoded = privateKeyPattern.matcher(pem).replaceFirst("$1");
        return Base64.getMimeDecoder().decode(encoded);
    }

    public static final List trace4cats$stackdriver$oauth$GoogleAccountParser$$anon$1$$_$apply$$anonfun$1(HCursor c$1) {
        return c$1.history();
    }

    public static final List trace4cats$stackdriver$oauth$GoogleAccountParser$$anon$1$$_$decodeAccumulating$$anonfun$1(HCursor c$2) {
        return c$2.history();
    }

    private final String parse$$anonfun$1(Path path$1) {
        return new String(Files.readAllBytes(path$1));
    }

    private final GoogleServiceAccount parse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(GoogleAccountParser.JsonGoogleServiceAccount serviceAccount$1) {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(this.loadPem(serviceAccount$1.private_key()));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return GoogleServiceAccount$.MODULE$.apply(serviceAccount$1.client_email(), (RSAPrivateKey)kf.generatePrivate(spec));
    }
}

