/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWK;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import java.security.MessageDigest;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface JWK {
    public static final MessageDigest DEFAULT_THUMBPRINT_DIGEST = AbstractJWK.getDefaultThumbprintDigest();
    public static final String USE_SIG = "sig";
    public static final String USE_ENC = "enc";
    public static final String KEY_OP_SIGN = "sign";
    public static final String KEY_OP_VERIFY = "verify";
    public static final String KEY_OP_ENCRYPT = "encrypt";
    public static final String KEY_OP_DECRYPT = "decrypt";
    public static final String KEY_OP_WRAP_KEY = "wrapKey";
    public static final String KEY_OP_UNWRAP_KEY = "unwrapKey";
    public static final String KEY_OP_DERIVE_KEY = "deriveKey";
    public static final String KEY_OP_DERIVE_BITS = "deriveBits";

    @JsonProperty(value="kty")
    public String getKeyType();

    @JsonProperty(value="use")
    public String getPublicKeyUse();

    @JsonProperty(value="key_ops")
    public Set<String> getKeyOperations();

    @JsonProperty(value="alg")
    public String getAlgorithm();

    @JsonProperty(value="kid")
    public String getKeyId();

    @JsonIgnore
    public boolean isTrusted();

    public JWK trust();

    public JWK toPublicJWK();

    public JWK minify();

    default public String toJWKThumbprint() {
        return this.toJWKThumbprint(DEFAULT_THUMBPRINT_DIGEST);
    }

    public String toJWKThumbprint(MessageDigest var1);

    public boolean supportsAlgorithm(String var1);

    public JWASigner signer() throws JWKProcessingException;

    public JWASigner signer(String var1) throws JWKProcessingException;

    public JWACipher cipher() throws JWKProcessingException;

    public JWACipher cipher(String var1) throws JWKProcessingException;

    public JWAKeyManager keyManager() throws JWKProcessingException;

    public JWAKeyManager keyManager(String var1) throws JWKProcessingException;

    public int hashCode();

    public boolean equals(Object var1);
}

