/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.internal.jwa.RSAKeyManager;
import io.inverno.mod.security.jose.internal.jwa.RSASigner;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.rsa.RSAJWK;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public enum RSAAlgorithm implements JWAAlgorithm<RSAJWK>
{
    RS1("RS1", RSAAlgorithm::createRSASigner, null, null, "SHA1withRSA"),
    RS256("RS256", RSAAlgorithm::createRSASigner, null, null, "SHA256withRSA"),
    RS384("RS384", RSAAlgorithm::createRSASigner, null, null, "SHA384withRSA"),
    RS512("RS512", RSAAlgorithm::createRSASigner, null, null, "SHA512withRSA"),
    PS256("PS256", RSAAlgorithm::createRSASigner, null, null, "RSASSA-PSS", new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1)),
    PS384("PS384", RSAAlgorithm::createRSASigner, null, null, "RSASSA-PSS", new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1)),
    PS512("PS512", RSAAlgorithm::createRSASigner, null, null, "RSASSA-PSS", new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1)),
    RSA1_5("RSA1_5", null, RSAAlgorithm::createRSAKeyManager, null, "RSA/ECB/PKCS1Padding"),
    RSA_OAEP("RSA-OAEP", null, RSAAlgorithm::createRSAKeyManager, null, "RSA/ECB/OAEPWithSHA-1AndMGF1Padding"),
    RSA_OAEP_256("RSA-OAEP-256", null, RSAAlgorithm::createRSAKeyManager, null, "RSA/ECB/OAEPWithSHA-256AndMGF1Padding", new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT)),
    RSA_OAEP_384("RSA-OAEP-384", null, RSAAlgorithm::createRSAKeyManager, null, "RSA/ECB/OAEPWithSHA-384AndMGF1Padding", new OAEPParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, PSource.PSpecified.DEFAULT)),
    RSA_OAEP_512("RSA-OAEP-512", null, RSAAlgorithm::createRSAKeyManager, null, "RSA/ECB/OAEPWithSHA-512AndMGF1Padding", new OAEPParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, PSource.PSpecified.DEFAULT));

    private final String alg;
    private final BiFunction<RSAJWK, RSAAlgorithm, JWASigner> signerFactory;
    private final BiFunction<RSAJWK, RSAAlgorithm, JWAKeyManager> keyManagerFactory;
    private final BiFunction<RSAJWK, RSAAlgorithm, JWACipher> cipherFactory;
    private final String jcaAlg;
    private final AlgorithmParameterSpec signatureParams;

    private RSAAlgorithm(String alg, BiFunction<RSAJWK, RSAAlgorithm, JWASigner> signerFactory, BiFunction<RSAJWK, RSAAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<RSAJWK, RSAAlgorithm, JWACipher> cipherFactory, String jcaAlg) {
        this(alg, signerFactory, keyManagerFactory, cipherFactory, jcaAlg, null);
    }

    private RSAAlgorithm(String alg, BiFunction<RSAJWK, RSAAlgorithm, JWASigner> signerFactory, BiFunction<RSAJWK, RSAAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<RSAJWK, RSAAlgorithm, JWACipher> cipherFactory, String jcaAlg, AlgorithmParameterSpec signatureParams) {
        this.alg = alg;
        this.jcaAlg = jcaAlg;
        this.signerFactory = signerFactory;
        this.keyManagerFactory = keyManagerFactory;
        this.cipherFactory = cipherFactory;
        this.signatureParams = signatureParams;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signerFactory != null;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagerFactory != null;
    }

    @Override
    public boolean isEncryption() {
        return this.cipherFactory != null;
    }

    @Override
    public JWASigner createSigner(RSAJWK jwk) throws JWAProcessingException {
        if (this.signerFactory == null) {
            throw new JWAProcessingException("Not a signature algorithm: " + this.alg);
        }
        return this.signerFactory.apply(jwk, this);
    }

    @Override
    public JWAKeyManager createKeyManager(RSAJWK jwk) throws JWAProcessingException {
        if (this.keyManagerFactory == null) {
            throw new JWAProcessingException("Not a key management algorithm: " + this.alg);
        }
        return this.keyManagerFactory.apply(jwk, this);
    }

    @Override
    public JWACipher createCipher(RSAJWK jwk) throws JWAProcessingException {
        if (this.cipherFactory == null) {
            throw new JWAProcessingException("Not an encryption algorithm: " + this.alg);
        }
        return this.cipherFactory.apply(jwk, this);
    }

    public String getJcaAlgorithm() {
        return this.jcaAlg;
    }

    public AlgorithmParameterSpec getSignatureParameter() {
        return this.signatureParams;
    }

    public static RSAAlgorithm fromAlgorithm(String alg) {
        switch (alg) {
            case "RS1": {
                return RS1;
            }
            case "RS256": {
                return RS256;
            }
            case "RS384": {
                return RS384;
            }
            case "RS512": {
                return RS512;
            }
            case "PS256": {
                return PS256;
            }
            case "PS384": {
                return PS384;
            }
            case "PS512": {
                return PS512;
            }
            case "RSA1_5": {
                return RSA1_5;
            }
            case "RSA-OAEP": {
                return RSA_OAEP;
            }
            case "RSA-OAEP-256": {
                return RSA_OAEP_256;
            }
            case "RSA-OAEP-384": {
                return RSA_OAEP_384;
            }
            case "RSA-OAEP-512": {
                return RSA_OAEP_512;
            }
        }
        throw new IllegalArgumentException("Unknown RSA algorithm " + alg);
    }

    private static RSASigner createRSASigner(RSAJWK jwk, RSAAlgorithm algorithm) throws JWAProcessingException {
        RSAAlgorithm rSAAlgorithm = algorithm;
        Objects.requireNonNull(rSAAlgorithm);
        return rSAAlgorithm.new InnerRSASigner(jwk);
    }

    private static RSAKeyManager createRSAKeyManager(RSAJWK jwk, RSAAlgorithm algorithm) throws JWAProcessingException {
        RSAAlgorithm rSAAlgorithm = algorithm;
        Objects.requireNonNull(rSAAlgorithm);
        return rSAAlgorithm.new InnerRSAKeyManager(jwk);
    }

    private class InnerRSASigner
    extends RSASigner {
        InnerRSASigner(RSAJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = RSAAlgorithm.this;
            this.init();
        }
    }

    private class InnerRSAKeyManager
    extends RSAKeyManager {
        InnerRSAKeyManager(RSAJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = RSAAlgorithm.this;
            this.init();
        }
    }
}

