/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.jwa;

import io.inverno.mod.security.jose.internal.jwa.EdDSASigner;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwk.okp.EdECJWK;
import java.util.Objects;
import java.util.function.BiFunction;

public enum EdECAlgorithm implements JWAAlgorithm<EdECJWK>
{
    EDDSA_ED25519("EdDSA", EdECAlgorithm::createEdDSASigner, null, null, "Ed25519", OKPCurve.ED25519),
    EDDSA_ED448("EdDSA", EdECAlgorithm::createEdDSASigner, null, null, "Ed448", OKPCurve.ED448);

    private final String alg;
    private final BiFunction<EdECJWK, EdECAlgorithm, JWASigner> signerFactory;
    private final BiFunction<EdECJWK, EdECAlgorithm, JWAKeyManager> keyManagerFactory;
    private final BiFunction<EdECJWK, EdECAlgorithm, JWACipher> cipherFactory;
    private final String jcaAlg;
    private final OKPCurve curve;

    private EdECAlgorithm(String alg, BiFunction<EdECJWK, EdECAlgorithm, JWASigner> signerFactory, BiFunction<EdECJWK, EdECAlgorithm, JWAKeyManager> keyManagerFactory, BiFunction<EdECJWK, EdECAlgorithm, JWACipher> cipherFactory, String jcaAlg, OKPCurve curve) {
        this.alg = alg;
        this.signerFactory = signerFactory;
        this.keyManagerFactory = keyManagerFactory;
        this.cipherFactory = cipherFactory;
        this.jcaAlg = jcaAlg;
        this.curve = curve;
    }

    @Override
    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public boolean isSignature() {
        return this.signerFactory != null;
    }

    @Override
    public boolean isKeyManagement() {
        return this.keyManagerFactory != null;
    }

    @Override
    public boolean isEncryption() {
        return this.cipherFactory != null;
    }

    @Override
    public JWASigner createSigner(EdECJWK jwk) throws JWAProcessingException {
        if (this.signerFactory == null) {
            throw new JWAProcessingException("Not a signature algorithm: " + this.alg);
        }
        return this.signerFactory.apply(jwk, this);
    }

    @Override
    public JWAKeyManager createKeyManager(EdECJWK jwk) throws JWAProcessingException {
        if (this.keyManagerFactory == null) {
            throw new JWAProcessingException("Not a key management algorithm: " + this.alg);
        }
        return this.keyManagerFactory.apply(jwk, this);
    }

    @Override
    public JWACipher createCipher(EdECJWK jwk) throws JWAProcessingException {
        if (this.cipherFactory == null) {
            throw new JWAProcessingException("Not an encryption algorithm: " + this.alg);
        }
        return this.cipherFactory.apply(jwk, this);
    }

    public String getJcaAlgorithm() {
        return this.jcaAlg;
    }

    public OKPCurve getCurve() {
        return this.curve;
    }

    public static EdECAlgorithm fromAlgorithm(String alg, OKPCurve curve) throws IllegalArgumentException {
        switch (alg) {
            case "EdDSA": {
                switch (curve) {
                    case ED25519: {
                        return EDDSA_ED25519;
                    }
                    case ED448: {
                        return EDDSA_ED448;
                    }
                }
                throw new IllegalArgumentException("Unkown EdDSA algorithm curve " + String.valueOf((Object)curve));
            }
        }
        throw new IllegalArgumentException("Unknown Ed algorithm " + alg);
    }

    private static EdDSASigner createEdDSASigner(EdECJWK jwk, EdECAlgorithm algorithm) throws JWAProcessingException {
        EdECAlgorithm edECAlgorithm = algorithm;
        Objects.requireNonNull(edECAlgorithm);
        return edECAlgorithm.new InnerEdDSASigner(jwk);
    }

    private class InnerEdDSASigner
    extends EdDSASigner {
        InnerEdDSASigner(EdECJWK jwk) throws JWAProcessingException {
            super(jwk);
            this.algorithm = EdECAlgorithm.this;
            this.init();
        }
    }
}

