/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import java.net.URI;
import java.util.Objects;

public class StringOrURI {
    private String str;
    private URI uri;

    public StringOrURI(String str) {
        Objects.requireNonNull(str);
        this.str = str;
    }

    public StringOrURI(URI uri) {
        Objects.requireNonNull(uri);
        this.uri = uri;
    }

    public String asString() {
        if (this.str == null) {
            this.str = this.uri.toString();
        }
        return this.str;
    }

    public URI asURI() {
        if (this.uri == null) {
            this.uri = URI.create(this.str);
        }
        return this.uri;
    }

    public int hashCode() {
        return Objects.hash(this.str, this.uri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringOrURI other = (StringOrURI)obj;
        return Objects.equals(this.str, other.str) && Objects.equals(this.uri, other.uri);
    }
}

