/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEBuilder;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwt.JWTBuildException;
import io.inverno.mod.security.jose.jwt.JWTClaimsSet;
import java.lang.reflect.Type;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class JWTEBuilder<A extends JWTClaimsSet>
extends GenericJWEBuilder<A> {
    public JWTEBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips) {
        super(mapper, dataConversionService, jwkService, type, keys, zips);
    }

    @Override
    public Mono<JWE<A>> build(String contentType) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return super.build("application/json");
    }

    @Override
    protected void checkHeader(JWEHeader header) throws JWTBuildException, JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        super.checkHeader(header);
        if (header.getContentType() != null) {
            throw new JWTBuildException("Content type is not allowed in JWT header: " + header.getContentType());
        }
        String headerType = header.getType();
        if (headerType != null && !headerType.equals("JWT")) {
            throw new JWTBuildException("Type must be JWT: " + headerType);
        }
    }
}

