/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwt;

import io.inverno.mod.base.converter.MediaTypeConverter;
import io.inverno.mod.base.resource.MediaTypes;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import java.util.Optional;

class JWTDataConversionService
implements DataConversionService {
    private final DataConversionService dataConversionService;
    private Optional<MediaTypeConverter<String>> jsonMediaTypeConverter;

    public JWTDataConversionService(DataConversionService dataConversionService) {
        this.dataConversionService = dataConversionService;
    }

    @Override
    public Optional<MediaTypeConverter<String>> getConverter(String mediaType) {
        String normalizedMediaType = MediaTypes.normalizeApplicationMediaType((String)mediaType);
        if (!normalizedMediaType.equals("application/json")) {
            return Optional.empty();
        }
        if (this.jsonMediaTypeConverter == null) {
            this.jsonMediaTypeConverter = this.dataConversionService.getConverter(normalizedMediaType);
        }
        return this.jsonMediaTypeConverter;
    }
}

