/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJsonJOSEObjectBuilder;
import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.internal.jws.GenericJsonJWS;
import io.inverno.mod.security.jose.internal.jws.JsonJWSHeader;
import io.inverno.mod.security.jose.internal.jws.SignatureJWSBuilder;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JsonJWS;
import io.inverno.mod.security.jose.jws.JsonJWSBuilder;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJsonJWSBuilder<A>
extends AbstractJsonJOSEObjectBuilder<A, JsonJWS<A, JsonJWS.BuiltSignature<A>>, GenericJWSHeader, GenericJsonJWSBuilder<A>>
implements JsonJWSBuilder<A, GenericJWSHeader, GenericJsonJWSBuilder<A>> {
    private final List<SignatureInfo> signatureInfos = new LinkedList<SignatureInfo>();

    public GenericJsonJWSBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type) {
        super(mapper, dataConversionService, jwkService, type);
    }

    @Override
    public GenericJsonJWSBuilder<A> signature(Consumer<GenericJWSHeader> protectedHeaderConfigurer, Consumer<GenericJWSHeader> unprotectedHeaderConfigurer, Publisher<? extends JWK> keys) {
        this.signatureInfos.add(new SignatureInfo(protectedHeaderConfigurer, unprotectedHeaderConfigurer, keys));
        return this;
    }

    @Override
    public Mono<JsonJWS<A, JsonJWS.BuiltSignature<A>>> build(String contentType) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.build(null, contentType);
    }

    @Override
    public Mono<JsonJWS<A, JsonJWS.BuiltSignature<A>>> build(Function<A, Mono<String>> payloadEncoder) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.build(payloadEncoder, null);
    }

    private Mono<JsonJWS<A, JsonJWS.BuiltSignature<A>>> build(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        String typ = null;
        String cty = null;
        Boolean b64 = null;
        for (SignatureInfo signatureInfo : this.signatureInfos) {
            signatureInfo.buildJWSHeaders();
            if (typ == null) {
                typ = signatureInfo.jwsHeader.getType();
            } else if (signatureInfo.jwsHeader.getType() != null && !typ.equals(signatureInfo.jwsHeader.getType())) {
                throw new JWSBuildException("Signatures have inconsistent types");
            }
            if (cty == null) {
                cty = signatureInfo.jwsHeader.getContentType();
            } else if (signatureInfo.jwsHeader.getContentType() != null && !cty.equals(signatureInfo.jwsHeader.getContentType())) {
                throw new JWSBuildException("Signatures have inconsistent content types");
            }
            if (b64 == null) {
                b64 = signatureInfo.jwsHeader.isBase64EncodePayload() == null || signatureInfo.jwsHeader.isBase64EncodePayload() != false;
                continue;
            }
            if ((b64.booleanValue() || signatureInfo.jwsHeader.isBase64EncodePayload() != null && !signatureInfo.jwsHeader.isBase64EncodePayload().booleanValue()) && (!b64.booleanValue() || signatureInfo.jwsHeader.isBase64EncodePayload() == null || signatureInfo.jwsHeader.isBase64EncodePayload().booleanValue())) continue;
            throw new JWSBuildException("Signatures have inconsistent base64 payload encoding");
        }
        return this.buildJWSPayload(overridingPayloadEncoder, overridingContentType, cty, b64).flatMap(jwsPayload -> Flux.fromIterable(this.signatureInfos).flatMap(signature -> new SignatureJWSBuilder(this.mapper, this.dataConversionService, this.jwkService, this.type, (Publisher<? extends JWK>)((Publisher<JWK>)signature.keys), signature.signatureProtectedJWSHeader, signature.jwsHeader, jwsPayload).build().map(jws -> new GenericJsonJWS.GenericBuiltSignature(signature.signatureProtectedJWSHeader, signature.signatureUnprotectedJWSHeader, jws))).collectList().map(signatures -> new GenericJsonJWS(this.mapper, jwsPayload, signatures)));
    }

    protected Mono<GenericJWSPayload<A>> buildJWSPayload(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, String cty, Boolean b64) throws JWSBuildException, JOSEObjectBuildException, JOSEProcessingException {
        this.checkPayload();
        return this.getPayloadEncoder(overridingPayloadEncoder, overridingContentType, cty).apply(this.payload).onErrorMap(e -> new JWSBuildException("Failed to encode JWS payload", (Throwable)e)).map(rawPayload -> {
            GenericJWSPayload<Object> jwsPayload = new GenericJWSPayload<Object>(this.payload);
            jwsPayload.setRaw((String)rawPayload);
            if (b64 == null || b64.booleanValue()) {
                jwsPayload.setEncoded(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(rawPayload.getBytes()));
            }
            return jwsPayload;
        });
    }

    protected class SignatureInfo {
        final Consumer<GenericJWSHeader> protectedHeaderConfigurer;
        final Consumer<GenericJWSHeader> unprotectedHeaderConfigurer;
        final Publisher<? extends JWK> keys;
        JsonJWSHeader signatureProtectedJWSHeader;
        JsonJWSHeader signatureUnprotectedJWSHeader;
        JsonJWSHeader jwsHeader;

        public SignatureInfo(Consumer<GenericJWSHeader> protectedHeaderConfigurer, Consumer<GenericJWSHeader> unprotectedHeaderConfigurer, Publisher<? extends JWK> keys) {
            this.protectedHeaderConfigurer = protectedHeaderConfigurer;
            this.unprotectedHeaderConfigurer = unprotectedHeaderConfigurer;
            this.keys = keys;
        }

        public void buildJWSHeaders() throws JWSBuildException {
            Set<String> overlappingParameters;
            this.jwsHeader = new JsonJWSHeader();
            this.jwsHeader.startRecordOverlap();
            if (GenericJsonJWSBuilder.this.protectedHeaderConfigurer != null) {
                this.signatureProtectedJWSHeader = new JsonJWSHeader();
                GenericJsonJWSBuilder.this.protectedHeaderConfigurer.accept(this.signatureProtectedJWSHeader);
                GenericJsonJWSBuilder.this.protectedHeaderConfigurer.accept(this.jwsHeader);
            }
            if (this.protectedHeaderConfigurer != null) {
                if (this.signatureProtectedJWSHeader == null) {
                    this.signatureProtectedJWSHeader = new JsonJWSHeader();
                } else {
                    this.signatureProtectedJWSHeader.startRecordOverlap();
                }
                this.protectedHeaderConfigurer.accept(this.signatureProtectedJWSHeader);
                this.protectedHeaderConfigurer.accept(this.jwsHeader);
                overlappingParameters = this.signatureProtectedJWSHeader.stopRecordOverlap();
                if (overlappingParameters != null && !overlappingParameters.isEmpty()) {
                    throw new JWSBuildException("Signature protected headers and enclosing JSON JWS protected headers must be disjoint: " + overlappingParameters.stream().collect(Collectors.joining(", ")));
                }
            }
            if (GenericJsonJWSBuilder.this.unprotectedHeaderConfigurer != null) {
                this.signatureUnprotectedJWSHeader = new JsonJWSHeader();
                GenericJsonJWSBuilder.this.unprotectedHeaderConfigurer.accept(this.signatureUnprotectedJWSHeader);
                GenericJsonJWSBuilder.this.unprotectedHeaderConfigurer.accept(this.jwsHeader);
            }
            if (this.unprotectedHeaderConfigurer != null) {
                if (this.signatureUnprotectedJWSHeader == null) {
                    this.signatureUnprotectedJWSHeader = new JsonJWSHeader();
                } else {
                    this.signatureUnprotectedJWSHeader.startRecordOverlap();
                }
                this.unprotectedHeaderConfigurer.accept(this.signatureUnprotectedJWSHeader);
                this.unprotectedHeaderConfigurer.accept(this.jwsHeader);
                overlappingParameters = this.signatureUnprotectedJWSHeader.stopRecordOverlap();
                if (overlappingParameters != null && !overlappingParameters.isEmpty()) {
                    throw new JWSBuildException("Signature unprotected headers and enclosing JSON JWS unprotected headers must be disjoint: " + overlappingParameters.stream().collect(Collectors.joining(", ")));
                }
            }
            if (!(overlappingParameters = this.jwsHeader.stopRecordOverlap()).isEmpty()) {
                throw new JWSBuildException("Protected and unprotected headers must be disjoint: " + overlappingParameters.stream().collect(Collectors.joining(", ")));
            }
            if (this.signatureUnprotectedJWSHeader != null) {
                if (this.signatureUnprotectedJWSHeader.getAlgorithm() != null) {
                    throw new JWSBuildException("Algorithm must be set in protected header");
                }
                if (this.signatureUnprotectedJWSHeader.getCritical() != null) {
                    throw new JWSBuildException("Critical must be set in protected header");
                }
            }
            if (this.jwsHeader.isBase64EncodePayload() != null) {
                if (this.signatureProtectedJWSHeader == null) {
                    this.signatureProtectedJWSHeader = new JsonJWSHeader();
                }
                if (this.signatureProtectedJWSHeader.getCritical() == null) {
                    this.signatureProtectedJWSHeader.critical("b64");
                }
                this.signatureProtectedJWSHeader.getCritical().add("b64");
            }
        }
    }
}

