/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEObjectReader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jws.GenericJWS;
import io.inverno.mod.security.jose.internal.jws.GenericJWSHeader;
import io.inverno.mod.security.jose.internal.jws.GenericJWSPayload;
import io.inverno.mod.security.jose.jwa.JWA;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwa.NoAlgorithm;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jws.JWS;
import io.inverno.mod.security.jose.jws.JWSBuildException;
import io.inverno.mod.security.jose.jws.JWSHeader;
import io.inverno.mod.security.jose.jws.JWSReadException;
import io.inverno.mod.security.jose.jws.JWSReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJWSReader<A>
extends AbstractJOSEObjectReader<A, JWSHeader, JWS<A>, GenericJWSReader<A>>
implements JWSReader<A, GenericJWSReader<A>> {
    private static final Logger LOGGER = LogManager.getLogger(GenericJWSReader.class);

    public GenericJWSReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys) {
        super(mapper, dataConversionService, jwkService, type, keys);
    }

    @Override
    public Mono<JWS<A>> read(String compact, String contentType) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(compact, null, contentType);
    }

    @Override
    public Mono<JWS<A>> read(String compact, Function<String, Mono<A>> payloadDecoder) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(compact, payloadDecoder, null);
    }

    private Mono<JWS<A>> read(String compact, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        String[] jwsParts = compact.split("\\.", -1);
        if (jwsParts.length != 3) {
            throw new JWSReadException("Invalid compact JWS");
        }
        GenericJWSHeader jwsHeader = this.readJWSHeader(jwsParts[0]);
        return this.readJWSPayload(jwsParts[1], overridingPayloadDecoder, overridingContentType, jwsHeader).flatMap(jwsPayload -> this.read(jwsHeader, (GenericJWSPayload<A>)jwsPayload, jwsParts[2], (Flux<? extends JWK>)this.getKeys(jwsHeader)));
    }

    private Mono<JWS<A>> read(GenericJWSHeader jwsHeader, GenericJWSPayload<A> jwsPayload, String encodedSignature, Flux<? extends JWK> keys) throws JWSReadException, JWSBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        if (jwsHeader.getAlgorithm().equals(NoAlgorithm.NONE.getAlgorithm())) {
            if (StringUtils.isNotBlank((CharSequence)encodedSignature)) {
                throw new JWSReadException("Unsecured JWS has a non-blank signature");
            }
            this.checkCriticalParameters(jwsHeader.getCritical(), new JWA[0]);
            return Mono.just(new GenericJWS<A>(jwsHeader, jwsPayload, null));
        }
        byte[] signingInput = (jwsHeader.getEncoded() + "." + jwsPayload.getEncoded()).getBytes();
        byte[] signature = Base64.getUrlDecoder().decode(encodedSignature);
        return Mono.defer(() -> {
            JWSReadException error = new JWSReadException("Failed to read JWS");
            return keys.onErrorStop().map(key -> {
                JWASigner signer = key.signer(jwsHeader.getAlgorithm());
                this.checkCriticalParameters(jwsHeader.getCritical(), signer);
                if (signer.verify(signingInput, signature)) {
                    jwsHeader.setKey((JWK)key);
                    return new GenericJWS(jwsHeader, jwsPayload, encodedSignature);
                }
                throw new JWSReadException("JWS signature is invalid with key: " + String.valueOf(key));
            }).onErrorContinue((e, key) -> {
                error.addSuppressed((Throwable)e);
                LOGGER.debug(() -> "Failed to read JWS with key: " + String.valueOf(key), e);
            }).next().switchIfEmpty(Mono.error((Throwable)error));
        });
    }

    protected GenericJWSHeader readJWSHeader(String encodedHeader) throws JWSReadException, JOSEObjectReadException, JOSEProcessingException {
        try {
            GenericJWSHeader jwsHeader = (GenericJWSHeader)this.mapper.readValue(Base64.getUrlDecoder().decode(encodedHeader), GenericJWSHeader.class);
            this.checkHeader(jwsHeader);
            jwsHeader.setEncoded(encodedHeader);
            return jwsHeader;
        }
        catch (IOException e) {
            throw new JWSReadException("Error decoding JOSE header", e);
        }
    }

    protected Mono<GenericJWSPayload<A>> readJWSPayload(String encodedPayload, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType, GenericJWSHeader jwsHeader) throws JWSReadException, JOSEObjectReadException, JOSEProcessingException {
        if (StringUtils.isBlank((CharSequence)encodedPayload)) {
            throw new JWSReadException("Payload is blank");
        }
        Function payloadDecoder = this.getPayloadDecoder(overridingPayloadDecoder, overridingContentType, jwsHeader);
        return Mono.defer(() -> {
            if (jwsHeader.isBase64EncodePayload() != null && !jwsHeader.isBase64EncodePayload().booleanValue()) {
                return ((Mono)payloadDecoder.apply(encodedPayload)).map(payload -> {
                    GenericJWSPayload<Object> jwsPayload = new GenericJWSPayload<Object>(payload);
                    jwsPayload.setRaw(encodedPayload);
                    return jwsPayload;
                });
            }
            return ((Mono)payloadDecoder.apply(new String(Base64.getUrlDecoder().decode(encodedPayload)))).map(payload -> {
                GenericJWSPayload<Object> jwsPayload = new GenericJWSPayload<Object>(payload);
                jwsPayload.setEncoded(encodedPayload);
                jwsPayload.setRaw(new String(Base64.getUrlDecoder().decode(encodedPayload)));
                return jwsPayload;
            });
        });
    }
}

