/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jws;

import com.fasterxml.jackson.annotation.JsonSetter;
import io.inverno.mod.security.jose.internal.AbstractJOSEHeader;
import io.inverno.mod.security.jose.jws.JWSHeader;
import io.inverno.mod.security.jose.jws.JWSHeaderConfigurator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenericJWSHeader
extends AbstractJOSEHeader<GenericJWSHeader>
implements JWSHeader,
JWSHeaderConfigurator<GenericJWSHeader> {
    public static final Set<String> PROCESSED_PARAMETERS = Stream.concat(AbstractJOSEHeader.PROCESSED_PARAMETERS.stream(), Stream.of("b64")).collect(Collectors.toSet());
    protected Boolean b64;

    public GenericJWSHeader() {
    }

    public GenericJWSHeader(String alg) {
        super(alg);
    }

    @Override
    public Set<String> getProcessedParameters() {
        return PROCESSED_PARAMETERS;
    }

    @Override
    public Boolean isBase64EncodePayload() {
        return this.b64;
    }

    @Override
    @JsonSetter(value="b64")
    public GenericJWSHeader base64EncodePayload(Boolean b64) {
        this.b64 = b64;
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.b64);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericJWSHeader other = (GenericJWSHeader)obj;
        return Objects.equals(this.b64, other.b64);
    }
}

