/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.okp.GenericXECJWK;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwa.XECAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.okp.XECJWKGenerator;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Map;
import reactor.core.publisher.Mono;

public class GenericXECJWKGenerator
extends AbstractOKPJWKGenerator<XECPublicKey, XECPrivateKey, GenericXECJWK, GenericXECJWKGenerator>
implements XECJWKGenerator<GenericXECJWK, GenericXECJWKGenerator> {
    public static final OKPCurve DEFAULT_CURVE = OKPCurve.X25519;
    private XECAlgorithm xecAlg;

    public GenericXECJWKGenerator() {
        this(null);
    }

    public GenericXECJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
        if (this.curve == null) {
            this.curve = DEFAULT_CURVE;
        }
    }

    @Override
    public GenericXECJWKGenerator algorithm(String alg) {
        this.xecAlg = alg != null ? XECAlgorithm.fromAlgorithm(alg) : null;
        return (GenericXECJWKGenerator)super.algorithm(alg);
    }

    @Override
    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return super.verify().then(Mono.fromRunnable(() -> {
            if (!GenericXECJWK.SUPPORTED_CURVES.contains((Object)this.curve)) {
                throw new JWKGenerateException("Unsupported OKP curve: " + this.curve.getCurve());
            }
        }));
    }

    @Override
    protected Mono<GenericXECJWK> doGenerate() {
        return Mono.fromSupplier(() -> {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.curve.getJCAName());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                XECPublicKey publicKey = (XECPublicKey)keyPair.getPublic();
                XECPrivateKey privateKey = (XECPrivateKey)keyPair.getPrivate();
                byte[] xBytes = new byte[this.curve.getKeyLength()];
                byte[] encodedKeyBytes = publicKey.getEncoded();
                System.arraycopy(encodedKeyBytes, encodedKeyBytes.length - xBytes.length, xBytes, 0, xBytes.length);
                GenericXECJWK jwk = new GenericXECJWK(this.curve, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(xBytes), privateKey.getScalar().map(JOSEUtils.BASE64_NOPAD_URL_ENCODER::encodeToString).orElse(null));
                jwk.setPublicKeyUse(this.use);
                jwk.setKeyOperations(this.key_ops);
                jwk.setKeyId(this.kid);
                jwk.setAlgorithm(this.alg);
                return jwk;
            }
            catch (NoSuchAlgorithmException e) {
                throw new JWKGenerateException("Error generating OKP JWK", e);
            }
        });
    }
}

