/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.okp;

import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.okp.AbstractOKPJWK;
import io.inverno.mod.security.jose.jwa.OKPCurve;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKBuildException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.JWKURLResolver;
import io.inverno.mod.security.jose.jwk.X509JWKCertPathValidator;
import io.inverno.mod.security.jose.jwk.okp.OKPJWK;
import io.inverno.mod.security.jose.jwk.okp.OKPJWKBuilder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public abstract class AbstractOKPJWKBuilder<A extends PublicKey, B extends PrivateKey, C extends OKPJWK<A, B>, D extends AbstractOKPJWKBuilder<A, B, C, D>>
extends AbstractX509JWKBuilder<A, B, C, D>
implements OKPJWKBuilder<A, B, C, D> {
    protected OKPCurve curve;
    protected String x;
    protected String d;

    public AbstractOKPJWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, JWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator) {
        this(configuration, jwkStore, keyResolver, urlResolver, certPathValidator, null);
    }

    public AbstractOKPJWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, JWKURLResolver urlResolver, X509JWKCertPathValidator certPathValidator, Map<String, Object> parameters) throws JWKReadException {
        super(configuration, jwkStore, keyResolver, urlResolver, certPathValidator, parameters);
    }

    @Override
    protected void set(String field, Object value) throws JWKReadException {
        switch (field) {
            case "crv": {
                this.curve((String)value);
                break;
            }
            case "x": {
                this.publicKey((String)value);
                break;
            }
            case "d": {
                this.privateKey((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public D curve(String crv) {
        this.curve = OKPCurve.fromCurve(crv);
        return (D)this;
    }

    @Override
    public D publicKey(String x) {
        this.x = x;
        return (D)this;
    }

    @Override
    public D privateKey(String d) {
        this.d = d;
        return (D)this;
    }

    @Override
    protected Mono<JWK> resolveFromJWKStore() throws JWKResolveException {
        String thumbprint = AbstractOKPJWK.toJWKThumbprint(JWK.DEFAULT_THUMBPRINT_DIGEST, this.curve != null ? this.curve.getCurve() : null, "OKP", this.x);
        return super.resolveFromJWKStore().switchIfEmpty(Mono.defer(() -> this.jwkStore.getByJWKThumbprint(thumbprint))).doOnNext(jwk -> {
            if (!(jwk instanceof OKPJWK)) {
                throw new JWKResolveException("Stored JWK is not of expected type: " + String.valueOf(OKPJWK.class));
            }
            OKPJWK okpJWK = (OKPJWK)jwk;
            if (this.curve != null && !this.curve.getCurve().equals(okpJWK.getCurve()) || this.x != null && !this.x.equals(okpJWK.getPublicKey()) || this.d != null && !this.d.equals(okpJWK.getPrivateKey())) {
                throw new JWKResolveException("JWK parameters does not match stored JWK");
            }
        });
    }

    @Override
    protected Mono<Void> resolve() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return super.resolve().then(Mono.fromRunnable(() -> {
            if (this.curve == null) {
                throw new JWKBuildException("Curve is null");
            }
            if (StringUtils.isBlank((CharSequence)this.x)) {
                throw new JWKBuildException("Public key is blank");
            }
        }));
    }
}

