/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.oct;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.core.annotation.Bean;
import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKFactory;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWK;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWKGenerator;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.oct.OCTJWKFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class GenericOCTJWKFactory
extends AbstractJWKFactory<GenericOCTJWK, GenericOCTJWKBuilder, GenericOCTJWKGenerator>
implements OCTJWKFactory<GenericOCTJWK, GenericOCTJWKBuilder, GenericOCTJWKGenerator> {
    private static final Set<String> SUPPORTED_ALGORITHMS = Arrays.stream(OCTAlgorithm.values()).map(OCTAlgorithm::getAlgorithm).collect(Collectors.toSet());

    public GenericOCTJWKFactory(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, ObjectMapper mapper) {
        super(configuration, jwkStore, keyResolver, mapper);
    }

    @Override
    public boolean supports(String kty) {
        return "oct".equals(kty);
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        return SUPPORTED_ALGORITHMS.contains(alg);
    }

    @Override
    public GenericOCTJWKBuilder builder() {
        return new GenericOCTJWKBuilder(this.configuration, this.jwkStore, this.keyResolver);
    }

    @Override
    public GenericOCTJWKBuilder builder(Map<String, Object> parameters) throws JWKReadException {
        return new GenericOCTJWKBuilder(this.configuration, this.jwkStore, this.keyResolver, parameters);
    }

    @Override
    public GenericOCTJWKGenerator generator() {
        return new GenericOCTJWKGenerator();
    }

    @Override
    public GenericOCTJWKGenerator generator(String alg, Map<String, Object> parameters) throws JWKGenerateException {
        return new GenericOCTJWKGenerator(parameters).algorithm(alg);
    }
}

