/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.oct;

import io.inverno.mod.security.jose.JOSEConfiguration;
import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWKBuilder;
import io.inverno.mod.security.jose.internal.jwk.oct.GenericOCTJWK;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKBuildException;
import io.inverno.mod.security.jose.jwk.JWKKeyResolver;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKReadException;
import io.inverno.mod.security.jose.jwk.JWKResolveException;
import io.inverno.mod.security.jose.jwk.JWKStore;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import io.inverno.mod.security.jose.jwk.oct.OCTJWKBuilder;
import java.math.BigInteger;
import java.security.Key;
import java.util.Base64;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Mono;

public class GenericOCTJWKBuilder
extends AbstractJWKBuilder<GenericOCTJWK, GenericOCTJWKBuilder>
implements OCTJWKBuilder<GenericOCTJWK, GenericOCTJWKBuilder> {
    private OCTAlgorithm octAlg;
    private String k;

    public GenericOCTJWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver) {
        this(configuration, jwkStore, keyResolver, null);
    }

    public GenericOCTJWKBuilder(JOSEConfiguration configuration, JWKStore jwkStore, JWKKeyResolver keyResolver, Map<String, Object> parameters) throws JWKReadException {
        super(configuration, jwkStore, keyResolver, parameters);
    }

    @Override
    protected void set(String field, Object value) throws JWKReadException {
        switch (field) {
            case "k": {
                this.keyValue((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public GenericOCTJWKBuilder algorithm(String alg) {
        this.octAlg = alg != null ? OCTAlgorithm.fromAlgorithm(alg) : null;
        return (GenericOCTJWKBuilder)super.algorithm(alg);
    }

    @Override
    public GenericOCTJWKBuilder keyValue(String k) {
        this.k = k;
        return this;
    }

    @Override
    protected Mono<JWK> resolveFromJWKStore() throws JWKResolveException {
        String thumbprint = GenericOCTJWK.toJWKThumbprint(JWK.DEFAULT_THUMBPRINT_DIGEST, this.k, "oct");
        return super.resolveFromJWKStore().switchIfEmpty(Mono.defer(() -> this.jwkStore.getByJWKThumbprint(thumbprint))).doOnNext(jwk -> {
            if (!(jwk instanceof OCTJWK)) {
                throw new JWKResolveException("Stored JWK is not of expected type: " + String.valueOf(OCTJWK.class));
            }
            OCTJWK octJWK = (OCTJWK)jwk;
            if (this.k != null && !this.k.equals(octJWK.getKeyValue())) {
                throw new JWKResolveException("JWK parameters does not match stored JWK");
            }
        });
    }

    @Override
    protected Mono<Void> resolveKey(Key key) throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return Mono.justOrEmpty((Object)key).flatMap(tmpKey -> {
            if (!(tmpKey instanceof SecretKey)) {
                throw new JWKBuildException("Key is not a secret key");
            }
            SecretKey secretKey = (SecretKey)tmpKey;
            if (this.k == null) {
                this.k = JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(secretKey.getEncoded());
            } else if (!new BigInteger(secretKey.getEncoded()).equals(new BigInteger(Base64.getUrlDecoder().decode(this.k)))) {
                throw new JWKBuildException("Resolved secret key does not match JWK parameters");
            }
            return Mono.empty();
        });
    }

    @Override
    protected Mono<Void> resolve() throws JWKBuildException, JWKResolveException, JWKProcessingException {
        return super.resolve().then(Mono.fromRunnable(() -> {
            if (StringUtils.isBlank((CharSequence)this.k)) {
                throw new JWKBuildException("Key value is blank");
            }
        }));
    }

    @Override
    public Mono<GenericOCTJWK> doBuild() throws JWKBuildException, JWKProcessingException {
        return Mono.fromSupplier(() -> {
            GenericOCTJWK jwk = new GenericOCTJWK(this.k, (SecretKey)this.key, this.key != null);
            jwk.setPublicKeyUse(this.use);
            jwk.setKeyOperations(this.key_ops);
            jwk.setAlgorithm(this.octAlg);
            jwk.setKeyId(this.kid);
            return jwk;
        });
    }
}

