/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.oct;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractJWK;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAKeyManagerException;
import io.inverno.mod.security.jose.jwa.JWASignatureException;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwa.NoAlgorithm;
import io.inverno.mod.security.jose.jwa.OCTAlgorithm;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class GenericOCTJWK
extends AbstractJWK
implements OCTJWK {
    private final String k;
    private OCTAlgorithm octAlg;
    private Optional<SecretKey> secretKey;
    private Map<OCTAlgorithm, JWASigner> signers;
    private Map<OCTAlgorithm, JWACipher> ciphers;
    private Map<OCTAlgorithm, JWAKeyManager> keyManagers;

    public GenericOCTJWK() {
        this(null, null, false);
    }

    public GenericOCTJWK(String k) {
        this(k, null, false);
    }

    public GenericOCTJWK(String k, SecretKey key, boolean trusted) {
        super("oct", key, trusted);
        this.k = k;
        this.secretKey = key != null ? Optional.of(key) : null;
    }

    public void setAlgorithm(OCTAlgorithm octAlg) {
        this.octAlg = octAlg;
        super.setAlgorithm(octAlg != null ? octAlg.getAlgorithm() : null);
    }

    @Override
    public void setAlgorithm(String alg) {
        this.octAlg = alg != null ? OCTAlgorithm.fromAlgorithm(alg) : null;
        super.setAlgorithm(alg);
    }

    @Override
    public String getKeyValue() {
        return this.k;
    }

    @Override
    public OCTJWK trust() {
        this.trusted = true;
        return this;
    }

    @Override
    public Optional<SecretKey> toSecretKey() throws JWKProcessingException {
        if (this.secretKey == null) {
            this.secretKey = Optional.ofNullable(this.k).map(sk -> new SecretKeySpec(Base64.getUrlDecoder().decode((String)sk), "AES"));
        }
        return this.secretKey;
    }

    @Override
    public OCTJWK toPublicJWK() {
        GenericOCTJWK jwk = new GenericOCTJWK();
        jwk.setAlgorithm(this.octAlg);
        jwk.setKeyId(this.kid);
        jwk.setKeyOperations(this.key_ops);
        jwk.setPublicKeyUse(this.use);
        return jwk;
    }

    @Override
    public OCTJWK minify() {
        GenericOCTJWK jwk = new GenericOCTJWK(this.k, (SecretKey)this.key, this.trusted);
        return jwk;
    }

    @Override
    public String toJWKThumbprint(MessageDigest digest) {
        return GenericOCTJWK.toJWKThumbprint(digest, this.k, this.kty);
    }

    static String toJWKThumbprint(MessageDigest digest, String k, String kty) {
        if (k == null || kty == null) {
            return null;
        }
        StringBuilder input = new StringBuilder();
        input.append('{');
        input.append("\"k\":\"").append(k).append("\",");
        input.append("\"kty\":\"").append(kty).append("\"");
        input.append('}');
        return JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(digest.digest(input.toString().getBytes()));
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        if (NoAlgorithm.DIR.getAlgorithm().equals(alg)) {
            return true;
        }
        try {
            OCTAlgorithm.fromAlgorithm(alg);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public JWASigner signer() throws JWKProcessingException {
        this.checkSignature(this.octAlg);
        return this.getSigner(this.octAlg);
    }

    @Override
    public JWASigner signer(String alg) {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.signer();
        }
        OCTAlgorithm algorithm = OCTAlgorithm.fromAlgorithm(alg);
        this.checkSignature(algorithm);
        return this.getSigner(algorithm);
    }

    @Override
    protected void checkSignature(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        super.checkSignature(algorithm);
        if (this.k == null) {
            throw new JWASignatureException("JWK secret key is missing");
        }
    }

    private JWASigner getSigner(OCTAlgorithm algorithm) {
        if (this.signers == null) {
            this.signers = new HashMap<OCTAlgorithm, JWASigner>();
        }
        return this.signers.computeIfAbsent(algorithm, ign -> algorithm.createSigner(this));
    }

    @Override
    public JWACipher cipher() throws JWKProcessingException {
        this.checkEncryption(this.octAlg);
        return this.getCipher(this.octAlg);
    }

    @Override
    public JWACipher cipher(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.cipher();
        }
        OCTAlgorithm algorithm = OCTAlgorithm.fromAlgorithm(alg);
        this.checkEncryption(algorithm);
        return this.getCipher(algorithm);
    }

    @Override
    protected void checkEncryption(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        super.checkEncryption(algorithm);
        if (this.k == null) {
            throw new JWASignatureException("JWK secret key is missing");
        }
    }

    private JWACipher getCipher(OCTAlgorithm algorithm) {
        if (this.ciphers == null) {
            this.ciphers = new HashMap<OCTAlgorithm, JWACipher>();
        }
        return this.ciphers.computeIfAbsent(algorithm, ign -> algorithm.createCipher(this));
    }

    @Override
    public JWAKeyManager keyManager() throws JWKProcessingException {
        this.checkKeyManagement(this.octAlg);
        return this.getKeyManager(this.octAlg);
    }

    @Override
    public JWAKeyManager keyManager(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.keyManager();
        }
        OCTAlgorithm algorithm = OCTAlgorithm.fromAlgorithm(alg);
        this.checkKeyManagement(algorithm);
        return this.getKeyManager(algorithm);
    }

    @Override
    protected void checkKeyManagement(JWAAlgorithm<?> algorithm) throws JWAKeyManagerException {
        super.checkKeyManagement(algorithm);
        if (this.k == null) {
            throw new JWAKeyManagerException("JWK secret key is missing");
        }
    }

    private JWAKeyManager getKeyManager(OCTAlgorithm algorithm) {
        if (this.keyManagers == null) {
            this.keyManagers = new HashMap<OCTAlgorithm, JWAKeyManager>();
        }
        return this.keyManagers.computeIfAbsent(algorithm, ign -> algorithm.createKeyManager(this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.k);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericOCTJWK other = (GenericOCTJWK)obj;
        return Objects.equals(this.k, other.k);
    }
}

