/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.ec;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWKGenerator;
import io.inverno.mod.security.jose.internal.jwk.ec.GenericECJWK;
import io.inverno.mod.security.jose.jwa.ECAlgorithm;
import io.inverno.mod.security.jose.jwa.ECCurve;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.ec.ECJWKGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Map;
import reactor.core.publisher.Mono;

public class GenericECJWKGenerator
extends AbstractX509JWKGenerator<ECPublicKey, ECPrivateKey, GenericECJWK, GenericECJWKGenerator>
implements ECJWKGenerator<GenericECJWK, GenericECJWKGenerator> {
    public static final ECCurve DEFAULT_CURVE = ECCurve.P_256;
    private ECAlgorithm ecAlg;
    private ECCurve curve;

    public GenericECJWKGenerator() {
        this(null);
    }

    public GenericECJWKGenerator(Map<String, Object> parameters) throws JWKGenerateException {
        super(parameters);
        if (this.curve == null) {
            this.curve = DEFAULT_CURVE;
        }
    }

    @Override
    protected void set(String field, Object value) throws JWKGenerateException {
        switch (field) {
            case "crv": {
                this.curve((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public GenericECJWKGenerator algorithm(String alg) {
        this.ecAlg = alg != null ? ECAlgorithm.fromAlgorithm(alg) : null;
        return (GenericECJWKGenerator)super.algorithm(alg);
    }

    @Override
    public GenericECJWKGenerator curve(String crv) {
        this.curve = crv != null ? ECCurve.fromCurve(crv) : DEFAULT_CURVE;
        return this;
    }

    @Override
    protected Mono<Void> verify() throws JWKGenerateException, JWKProcessingException {
        return super.verify().then(Mono.fromRunnable(() -> {
            if (this.ecAlg != null && this.ecAlg.getCurve() != null && !this.curve.equals((Object)this.ecAlg.getCurve())) {
                throw new JWKGenerateException("JWK with curve " + this.curve.getCurve() + " does not support algorithm " + this.ecAlg.getAlgorithm());
            }
        }));
    }

    @Override
    protected Mono<GenericECJWK> doGenerate() throws JWKGenerateException, JWKProcessingException {
        return Mono.fromSupplier(() -> {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
                keyPairGenerator.initialize(new ECGenParameterSpec(this.curve.getJCAName()));
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
                ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
                GenericECJWK jwk = new GenericECJWK(this.curve, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toPaddedUnsignedBytes(publicKey.getW().getAffineX(), this.curve.getKeyLength())), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toPaddedUnsignedBytes(publicKey.getW().getAffineY(), this.curve.getKeyLength())), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(JOSEUtils.toPaddedUnsignedBytes(privateKey.getS(), this.curve.getKeyLength())));
                jwk.setPublicKeyUse(this.use);
                jwk.setKeyOperations(this.key_ops);
                jwk.setKeyId(this.kid);
                jwk.setAlgorithm(this.alg);
                return jwk;
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                throw new JWKGenerateException("Error generating EC JWK", e);
            }
        });
    }
}

