/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwk.ec;

import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.jwk.AbstractX509JWK;
import io.inverno.mod.security.jose.jwa.ECAlgorithm;
import io.inverno.mod.security.jose.jwa.ECCurve;
import io.inverno.mod.security.jose.jwa.JWAAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWASigner;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.ec.ECJWK;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class GenericECJWK
extends AbstractX509JWK<ECPublicKey, ECPrivateKey>
implements ECJWK {
    private final ECCurve curve;
    private final String x;
    private final String y;
    private final String d;
    private ECAlgorithm ecAlg;
    private ECPublicKey publicKey;
    private Optional<ECPrivateKey> privateKey;
    private JWASigner signer;
    private Map<ECAlgorithm, JWAKeyManager> keyManagers;

    public GenericECJWK(ECCurve curve, String x, String y) {
        this(curve, x, y, null, null, null, false);
    }

    public GenericECJWK(ECCurve curve, String x, String y, X509Certificate certificate) {
        this(curve, x, y, null, null, certificate, certificate != null);
    }

    public GenericECJWK(ECCurve curve, String x, String y, String d) {
        this(curve, x, y, d, null, null, false);
    }

    public GenericECJWK(ECCurve curve, String x, String y, String d, ECPrivateKey key, boolean trusted) {
        this(curve, x, y, d, key, null, trusted);
    }

    public GenericECJWK(ECCurve curve, String x, String y, String d, X509Certificate certificate) {
        this(curve, x, y, d, null, certificate, certificate != null);
    }

    public GenericECJWK(ECCurve curve, String x, String y, String d, ECPrivateKey key, X509Certificate certificate, boolean trusted) {
        super("EC", key, certificate, trusted);
        this.curve = curve;
        this.x = x;
        this.y = y;
        this.d = d;
        this.privateKey = key != null ? Optional.of(key) : null;
    }

    public void setAlgorithm(ECAlgorithm ecAlg) {
        this.ecAlg = ecAlg;
        super.setAlgorithm(ecAlg != null ? ecAlg.getAlgorithm() : null);
    }

    @Override
    public void setAlgorithm(String alg) {
        this.ecAlg = alg != null ? ECAlgorithm.fromAlgorithm(alg) : null;
        super.setAlgorithm(alg);
    }

    @Override
    public String getCurve() {
        return this.curve.getCurve();
    }

    @Override
    public String getXCoordinate() {
        return this.x;
    }

    @Override
    public String getYCoordinate() {
        return this.y;
    }

    @Override
    public String getEccPrivateKey() {
        return this.d;
    }

    @Override
    public ECJWK trust() {
        this.trusted = true;
        return this;
    }

    @Override
    public ECPublicKey toPublicKey() throws JWKProcessingException {
        if (this.publicKey == null) {
            this.publicKey = this.certificate.map(cert -> (ECPublicKey)cert.getPublicKey()).orElseGet(() -> {
                try {
                    ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(1, Base64.getUrlDecoder().decode(this.x)), new BigInteger(1, Base64.getUrlDecoder().decode(this.y))), this.curve.getParameterSpec());
                    return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(ecPublicKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error creating verifier", e);
                }
            });
        }
        return this.publicKey;
    }

    @Override
    public Optional<ECPrivateKey> toPrivateKey() throws JWKProcessingException {
        if (this.privateKey == null) {
            this.privateKey = Optional.ofNullable(this.d).map(pk -> {
                try {
                    ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(new BigInteger(1, Base64.getUrlDecoder().decode((String)pk)), this.curve.getParameterSpec());
                    return (ECPrivateKey)KeyFactory.getInstance("EC").generatePrivate(ecPrivateKeySpec);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new JWKProcessingException("Error creating signer", e);
                }
            });
        }
        return this.privateKey;
    }

    @Override
    public ECJWK toPublicJWK() {
        GenericECJWK jwk = new GenericECJWK(this.curve, this.x, this.y, this.certificate.orElse(null));
        jwk.publicKey = this.publicKey;
        jwk.setPublicKeyUse(this.use);
        jwk.setKeyOperations(this.key_ops);
        jwk.setAlgorithm(this.ecAlg);
        jwk.setKeyId(this.kid);
        jwk.setX509CertificateURL(this.x5u);
        jwk.setX509CertificateChain(this.x5c);
        jwk.setX509CertificateSHA1Thumbprint(this.x5t);
        jwk.setX509CertificateSHA256Thumbprint(this.x5t_S256);
        return jwk;
    }

    @Override
    public ECJWK minify() {
        GenericECJWK jwk = new GenericECJWK(this.curve, this.x, this.y, this.d, (ECPrivateKey)this.key, this.certificate.orElse(null), this.trusted);
        jwk.publicKey = this.publicKey;
        return jwk;
    }

    @Override
    public String toJWKThumbprint(MessageDigest digest) {
        return GenericECJWK.toJWKThumbprint(digest, this.curve.getCurve(), this.kty, this.x, this.y);
    }

    static String toJWKThumbprint(MessageDigest digest, String crv, String kty, String x, String y) {
        if (crv == null || kty == null || x == null || y == null) {
            return null;
        }
        StringBuilder input = new StringBuilder();
        input.append('{');
        input.append("\"crv\":\"").append(crv).append("\",");
        input.append("\"kty\":\"").append(kty).append("\",");
        input.append("\"x\":\"").append(x).append("\",");
        input.append("\"y\":\"").append(y).append("\"");
        input.append('}');
        return JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(digest.digest(input.toString().getBytes()));
    }

    @Override
    public boolean supportsAlgorithm(String alg) {
        try {
            ECAlgorithm algorithm = ECAlgorithm.fromAlgorithm(alg);
            return algorithm.getCurve() == null || algorithm.getCurve().equals((Object)this.curve);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public JWASigner signer() throws JWKProcessingException {
        this.checkSignature(this.ecAlg);
        if (this.signer == null) {
            this.signer = this.ecAlg.createSigner(this);
        }
        return this.signer;
    }

    @Override
    public JWASigner signer(String alg) {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.signer();
        }
        ECAlgorithm algorithm = ECAlgorithm.fromAlgorithm(alg);
        this.checkSignature(algorithm);
        if (this.signer == null) {
            this.signer = algorithm.createSigner(this);
        }
        return this.signer;
    }

    @Override
    protected void checkSignature(JWAAlgorithm<?> algorithm) throws JWKProcessingException {
        super.checkSignature(algorithm);
        if (!this.curve.equals((Object)((ECAlgorithm)algorithm).getCurve())) {
            throw new JWKProcessingException("JWK with curve " + String.valueOf((Object)this.curve) + " doesn't support algorithm " + String.valueOf(algorithm));
        }
    }

    @Override
    public JWAKeyManager keyManager() throws JWKProcessingException {
        this.checkKeyManagement(this.ecAlg);
        return this.getKeyManager(this.ecAlg);
    }

    @Override
    public JWAKeyManager keyManager(String alg) throws JWKProcessingException {
        if (StringUtils.isBlank((CharSequence)alg)) {
            return this.keyManager();
        }
        ECAlgorithm algorithm = ECAlgorithm.fromAlgorithm(alg);
        this.checkKeyManagement(algorithm);
        return this.getKeyManager(algorithm);
    }

    private JWAKeyManager getKeyManager(ECAlgorithm algorithm) {
        if (this.keyManagers == null) {
            this.keyManagers = new HashMap<ECAlgorithm, JWAKeyManager>();
        }
        return this.keyManagers.computeIfAbsent(algorithm, ign -> algorithm.createKeyManager(this));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.curve, this.d, this.x, this.y});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericECJWK other = (GenericECJWK)obj;
        return this.curve == other.curve && Objects.equals(this.d, other.d) && Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y);
    }
}

