/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEObjectReadException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJsonJOSEObjectReader;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJsonJWE;
import io.inverno.mod.security.jose.internal.jwe.JsonJWEHeader;
import io.inverno.mod.security.jose.internal.jwe.RecipientJWEReader;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEReadException;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwe.JsonJWE;
import io.inverno.mod.security.jose.jwe.JsonJWEReader;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJsonJWEReader<A>
extends AbstractJsonJOSEObjectReader<A, JsonJWE<A, JsonJWE.ReadRecipient<A>>, GenericJsonJWEReader<A>>
implements JsonJWEReader<A, GenericJsonJWEReader<A>> {
    private final List<JWEZip> zips;

    public GenericJsonJWEReader(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, List<JWEZip> zips) {
        super(mapper, dataConversionService, jwkService, type);
        this.zips = zips;
    }

    @Override
    public Mono<JsonJWE<A, JsonJWE.ReadRecipient<A>>> read(String json, String contentType) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(json, null, contentType);
    }

    @Override
    public Mono<JsonJWE<A, JsonJWE.ReadRecipient<A>>> read(String json, Function<String, Mono<A>> payloadDecoder) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        return this.read(json, payloadDecoder, null);
    }

    private Mono<JsonJWE<A, JsonJWE.ReadRecipient<A>>> read(String json, Function<String, Mono<A>> overridingPayloadDecoder, String overridingContentType) throws JWEReadException, JWEBuildException, JOSEObjectReadException, JOSEObjectBuildException, JOSEProcessingException {
        byte[] raw_aad;
        List recipientsValue;
        String tagValue;
        String ciphertextValue;
        String ivValue;
        String aadValue;
        Map unprotectedValue;
        String protectedValue;
        Map parsedJson;
        try {
            parsedJson = (Map)this.mapper.readerForMapOf(Object.class).readValue(json);
        }
        catch (JsonProcessingException e) {
            throw new JWEReadException("Invalid Json JWE", e);
        }
        try {
            protectedValue = (String)parsedJson.get("protected");
            unprotectedValue = (Map)parsedJson.get("unprotected");
            aadValue = (String)parsedJson.get("aad");
            ivValue = (String)parsedJson.get("iv");
            ciphertextValue = (String)parsedJson.get("ciphertext");
            tagValue = (String)parsedJson.get("tag");
            recipientsValue = (List)parsedJson.get("recipients");
        }
        catch (ClassCastException e) {
            throw new JWEReadException("Invalid Json JWE", e);
        }
        JsonJWEHeader protectedJWEHeader = this.readProtectedJWEHeader(protectedValue);
        JsonJWEHeader unprotectedJWEHeader = this.readUnprotectedJWEHeader(unprotectedValue);
        if (protectedJWEHeader != null && unprotectedJWEHeader != null) {
            HashSet<String> overlappingParameters = new HashSet<String>(protectedJWEHeader.getParametersSet());
            overlappingParameters.retainAll(unprotectedJWEHeader.getParametersSet());
            if (!overlappingParameters.isEmpty()) {
                throw new JWEReadException("Protected and unprotected headers must be disjoint: " + overlappingParameters.stream().collect(Collectors.joining(", ")));
            }
        }
        if (aadValue != null) {
            byte[] encodedProtectedHeader = protectedJWEHeader != null ? protectedJWEHeader.getEncoded().getBytes(StandardCharsets.US_ASCII) : new byte[]{};
            byte[] encodedAAD = aadValue.getBytes(StandardCharsets.US_ASCII);
            raw_aad = new byte[encodedProtectedHeader.length + 1 + encodedAAD.length];
            System.arraycopy(encodedProtectedHeader, 0, raw_aad, 0, encodedProtectedHeader.length);
            raw_aad[encodedProtectedHeader.length] = 46;
            System.arraycopy(encodedAAD, 0, raw_aad, encodedProtectedHeader.length + 1, encodedAAD.length);
        } else {
            raw_aad = protectedJWEHeader != null ? protectedJWEHeader.getEncoded().getBytes(StandardCharsets.US_ASCII) : new byte[]{};
        }
        String typ = null;
        String cty = null;
        String enc = null;
        String zip = null;
        LinkedList<RecipientInfo> recipientInfos = new LinkedList<RecipientInfo>();
        if (recipientsValue != null) {
            for (Object recipientElement : recipientsValue) {
                RecipientInfo recipientInfo2 = this.readJWERecipient(recipientElement, protectedJWEHeader, unprotectedJWEHeader);
                if (typ == null) {
                    typ = recipientInfo2.jweHeader.getType();
                } else if (recipientInfo2.jweHeader.getType() != null && !typ.equals(recipientInfo2.jweHeader.getType())) {
                    throw new JWEReadException("Recipients have inconsistent types");
                }
                if (cty == null) {
                    cty = recipientInfo2.jweHeader.getContentType();
                } else if (recipientInfo2.jweHeader.getContentType() != null && !cty.equals(recipientInfo2.jweHeader.getContentType())) {
                    throw new JWEReadException("Recipients have inconsistent content types");
                }
                if (enc == null) {
                    enc = recipientInfo2.jweHeader.getEncryptionAlgorithm();
                } else if (recipientInfo2.jweHeader.getEncryptionAlgorithm() != null && !enc.equals(recipientInfo2.jweHeader.getEncryptionAlgorithm())) {
                    throw new JWEReadException("Recipients have inconsistent encryption algorithms");
                }
                if (zip == null) {
                    zip = recipientInfo2.jweHeader.getCompressionAlgorithm();
                } else if (recipientInfo2.jweHeader.getCompressionAlgorithm() != null && !zip.equals(recipientInfo2.jweHeader.getCompressionAlgorithm())) {
                    throw new JWEReadException("Recipients have inconsistent compression algorithms");
                }
                recipientInfos.add(recipientInfo2);
            }
        } else {
            RecipientInfo recipientInfo3 = this.readJWERecipient(parsedJson, protectedJWEHeader, unprotectedJWEHeader);
            typ = recipientInfo3.jweHeader.getType();
            cty = recipientInfo3.jweHeader.getContentType();
            enc = recipientInfo3.jweHeader.getEncryptionAlgorithm();
            zip = recipientInfo3.jweHeader.getCompressionAlgorithm();
            recipientInfos.add(recipientInfo3);
        }
        Function<String, Mono<A>> payloadDecoder = this.getPayloadDecoder(overridingPayloadDecoder, overridingContentType, cty);
        return Flux.fromIterable(recipientInfos).map(recipientInfo -> new GenericJsonJWE.GenericReadRecipient(recipientInfo.recipientJWEHeader, recipientInfo.encrypted_key, keys -> new RecipientJWEReader(this.mapper, this.dataConversionService, this.jwkService, this.type, (Publisher<? extends JWK>)keys, this.zips, recipientInfo.jweHeader, raw_aad).read("." + recipientInfo.encrypted_key + "." + ivValue + "." + ciphertextValue + "." + tagValue, payloadDecoder))).collectList().map(recipients -> new GenericJsonJWE(protectedJWEHeader, unprotectedJWEHeader, ivValue, aadValue, ciphertextValue, tagValue, recipients, this.mapper));
    }

    protected JsonJWEHeader readProtectedJWEHeader(String protectedValue) throws JWEReadException, JOSEObjectReadException, JOSEProcessingException {
        if (protectedValue == null) {
            return null;
        }
        try {
            JsonJWEHeader protectedHeader = (JsonJWEHeader)this.mapper.readValue(Base64.getUrlDecoder().decode(protectedValue), JsonJWEHeader.class);
            protectedHeader.setEncoded(protectedValue);
            return protectedHeader;
        }
        catch (IOException e) {
            throw new JWEReadException("Failed to decode Json JWE protected header", e);
        }
    }

    protected JsonJWEHeader readUnprotectedJWEHeader(Map<String, Object> unprotectedValue) throws JWEReadException, JOSEObjectReadException, JOSEProcessingException {
        if (unprotectedValue == null) {
            return null;
        }
        return (JsonJWEHeader)this.mapper.convertValue(unprotectedValue, JsonJWEHeader.class);
    }

    protected RecipientInfo readJWERecipient(Object recipientElementValue, JsonJWEHeader protectedJWEHeader, JsonJWEHeader unprotectedJWEHeader) throws JWEReadException, JOSEObjectReadException, JOSEProcessingException {
        JsonJWEHeader recipientJWEHeader;
        String encrypted_keyValue;
        Map headerValue;
        try {
            Map recipientElement = (Map)recipientElementValue;
            headerValue = (Map)recipientElement.get("header");
            encrypted_keyValue = (String)recipientElement.get("encrypted_key");
        }
        catch (ClassCastException e) {
            throw new JWEReadException("Invalid recipient element", e);
        }
        if (encrypted_keyValue == null) {
            throw new JWEReadException("Missing encrypted key field");
        }
        JsonJWEHeader jsonJWEHeader = recipientJWEHeader = headerValue != null ? (JsonJWEHeader)this.mapper.convertValue((Object)headerValue, JsonJWEHeader.class) : null;
        if (recipientJWEHeader != null) {
            Set<String> overlappingParameters = recipientJWEHeader.getParametersSet();
            overlappingParameters.retainAll(protectedJWEHeader.getParametersSet());
            overlappingParameters.retainAll(unprotectedJWEHeader.getParametersSet());
            if (!overlappingParameters.isEmpty()) {
                throw new JWEReadException("Recipient, protected and unprotected headers must be disjoint: " + overlappingParameters.stream().collect(Collectors.joining(", ")));
            }
        }
        return new RecipientInfo(recipientJWEHeader, new JsonJWEHeader().merge(protectedJWEHeader).merge(unprotectedJWEHeader).merge(recipientJWEHeader), encrypted_keyValue);
    }

    protected static class RecipientInfo {
        private final JsonJWEHeader recipientJWEHeader;
        private final JsonJWEHeader jweHeader;
        private final String encrypted_key;

        public RecipientInfo(JsonJWEHeader recipientJWEHeader, JsonJWEHeader jweHeader, String encrypted_key) {
            this.recipientJWEHeader = recipientJWEHeader;
            this.jweHeader = jweHeader;
            this.encrypted_key = encrypted_key;
        }
    }
}

