/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.inverno.mod.security.jose.JOSEObjectBuildException;
import io.inverno.mod.security.jose.JOSEProcessingException;
import io.inverno.mod.security.jose.internal.AbstractJOSEObjectBuilder;
import io.inverno.mod.security.jose.internal.JOSEUtils;
import io.inverno.mod.security.jose.internal.converter.DataConversionService;
import io.inverno.mod.security.jose.internal.jwe.GenericJWE;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEHeader;
import io.inverno.mod.security.jose.internal.jwe.GenericJWEPayload;
import io.inverno.mod.security.jose.jwa.DirectJWAKeyManager;
import io.inverno.mod.security.jose.jwa.EncryptingJWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWACipher;
import io.inverno.mod.security.jose.jwa.JWACipherException;
import io.inverno.mod.security.jose.jwa.JWAKeyManager;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.NoAlgorithm;
import io.inverno.mod.security.jose.jwa.WrappingJWAKeyManager;
import io.inverno.mod.security.jose.jwe.JWE;
import io.inverno.mod.security.jose.jwe.JWEBuildException;
import io.inverno.mod.security.jose.jwe.JWEBuilder;
import io.inverno.mod.security.jose.jwe.JWEHeader;
import io.inverno.mod.security.jose.jwe.JWEZip;
import io.inverno.mod.security.jose.jwe.JWEZipException;
import io.inverno.mod.security.jose.jwk.JWK;
import io.inverno.mod.security.jose.jwk.JWKGenerateException;
import io.inverno.mod.security.jose.jwk.JWKProcessingException;
import io.inverno.mod.security.jose.jwk.JWKService;
import io.inverno.mod.security.jose.jwk.oct.OCTJWK;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GenericJWEBuilder<A>
extends AbstractJOSEObjectBuilder<A, JWEHeader, JWE<A>, GenericJWEHeader, GenericJWEBuilder<A>>
implements JWEBuilder<A, GenericJWEHeader, GenericJWEBuilder<A>> {
    private static final Logger LOGGER = LogManager.getLogger(GenericJWEBuilder.class);
    private final List<JWEZip> zips;
    private SecureRandom secureRandom = JOSEUtils.DEFAULT_SECURE_RANDOM;
    protected Consumer<GenericJWEHeader> headerConfigurer;

    public GenericJWEBuilder(ObjectMapper mapper, DataConversionService dataConversionService, JWKService jwkService, Type type, Publisher<? extends JWK> keys, List<JWEZip> zips) {
        super(mapper, dataConversionService, jwkService, type, keys);
        this.zips = zips;
    }

    @Override
    public GenericJWEBuilder<A> header(Consumer<GenericJWEHeader> configurer) {
        this.headerConfigurer = configurer;
        return this;
    }

    @Override
    public GenericJWEBuilder<A> secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom != null ? secureRandom : JOSEUtils.DEFAULT_SECURE_RANDOM;
        return this;
    }

    @Override
    public Mono<JWE<A>> build(String contentType) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.build(null, contentType);
    }

    @Override
    public Mono<JWE<A>> build(Function<A, Mono<String>> payloadEncoder) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        return this.build(payloadEncoder, null);
    }

    private Mono<JWE<A>> build(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        GenericJWEHeader jweHeader = this.buildJWEHeader();
        return this.buildJWEPayload(overridingPayloadEncoder, overridingContentType, jweHeader).flatMap(jwePayload -> this.build(jweHeader, (GenericJWEPayload<A>)jwePayload, (Flux<? extends JWK>)this.getKeys(jweHeader)));
    }

    private Mono<JWE<A>> build(GenericJWEHeader jweHeader, GenericJWEPayload<A> jwePayload, Flux<? extends JWK> keys) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        JWEZip payloadZip = this.getPayloadZip(jweHeader);
        if (jweHeader.getAlgorithm().equals(NoAlgorithm.DIR.getAlgorithm())) {
            this.amendJWEHeader(jweHeader, null, null);
            return Mono.defer(() -> {
                JWEBuildException error = new JWEBuildException("Failed to build JWE");
                return keys.onErrorStop().map(key -> {
                    JWACipher.EncryptedData encryptedData = this.zipAndEncryptPayload(jweHeader, jwePayload, payloadZip, (JWK)key);
                    return new GenericJWE(jweHeader, jwePayload, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getInitializationVector()), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getAuthenticationTag()));
                }).onErrorContinue((e, key) -> {
                    error.addSuppressed((Throwable)e);
                    LOGGER.debug(() -> "Failed to build JWE with key: " + String.valueOf(key), e);
                }).next().switchIfEmpty(Mono.error((Throwable)error));
            });
        }
        Flux ceks = this.generateCEK(jweHeader).cache();
        return Mono.defer(() -> {
            JWEBuildException error = new JWEBuildException("Failed to build JWE");
            return keys.onErrorStop().flatMap(key -> {
                JWAKeyManager keyManager = key.keyManager(jweHeader.getAlgorithm());
                if (keyManager instanceof DirectJWAKeyManager) {
                    DirectJWAKeyManager.DirectCEK directCEK = ((DirectJWAKeyManager)keyManager).deriveCEK(jweHeader.getEncryptionAlgorithm(), jweHeader.getCustomParameters());
                    OCTJWK cek2 = directCEK.getEncryptionKey();
                    this.amendJWEHeader(jweHeader, directCEK.getMoreHeaderParameters(), keyManager.getProcessedParameters());
                    JWACipher.EncryptedData encryptedData = this.zipAndEncryptPayload(jweHeader, jwePayload, payloadZip, cek2);
                    return Mono.just(new GenericJWE(jweHeader, jwePayload, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getInitializationVector()), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getAuthenticationTag())));
                }
                if (keyManager instanceof EncryptingJWAKeyManager) {
                    return ceks.mapNotNull(cek -> {
                        EncryptingJWAKeyManager.EncryptedCEK encryptedCEK = ((EncryptingJWAKeyManager)keyManager).encryptCEK((JWK)cek, jweHeader.getCustomParameters(), this.secureRandom);
                        this.amendJWEHeader(jweHeader, encryptedCEK.getMoreHeaderParameters(), keyManager.getProcessedParameters());
                        JWACipher.EncryptedData encryptedData = this.zipAndEncryptPayload(jweHeader, jwePayload, payloadZip, (JWK)cek);
                        return new GenericJWE(jweHeader, jwePayload, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getInitializationVector()), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getAuthenticationTag()), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedCEK.getEncryptedKey()), (JWK)cek);
                    });
                }
                if (keyManager instanceof WrappingJWAKeyManager) {
                    return ceks.mapNotNull(cek -> {
                        WrappingJWAKeyManager.WrappedCEK wrappedCEK = ((WrappingJWAKeyManager)keyManager).wrapCEK((JWK)cek, jweHeader.getCustomParameters(), this.secureRandom);
                        this.amendJWEHeader(jweHeader, wrappedCEK.getMoreHeaderParameters(), keyManager.getProcessedParameters());
                        JWACipher.EncryptedData encryptedData = this.zipAndEncryptPayload(jweHeader, jwePayload, payloadZip, (JWK)cek);
                        return new GenericJWE(jweHeader, jwePayload, JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getInitializationVector()), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getAuthenticationTag()), JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(wrappedCEK.getWrappedKey()), (JWK)cek);
                    });
                }
                throw new JWAProcessingException("Key manager must implement " + String.valueOf(DirectJWAKeyManager.class) + ", " + String.valueOf(EncryptingJWAKeyManager.class) + " or " + String.valueOf(WrappingJWAKeyManager.class));
            }).onErrorContinue((e, key) -> {
                error.addSuppressed((Throwable)e);
                LOGGER.debug(() -> "Failed to build JWE with key: " + String.valueOf(key), e);
            }).next().switchIfEmpty(Mono.error((Throwable)error));
        });
    }

    @Override
    protected Set<String> getProcessedParameters() {
        return GenericJWEHeader.PROCESSED_PARAMETERS;
    }

    @Override
    protected void checkHeader(JWEHeader header) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        super.checkHeader(header);
        if (StringUtils.isBlank((CharSequence)header.getEncryptionAlgorithm())) {
            throw new JWEBuildException("Encryption algorithm is blank");
        }
    }

    protected GenericJWEHeader buildJWEHeader() throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        GenericJWEHeader jweHeader = new GenericJWEHeader();
        if (this.headerConfigurer != null) {
            this.headerConfigurer.accept(jweHeader);
        }
        this.checkHeader(jweHeader);
        return jweHeader;
    }

    protected Mono<GenericJWEPayload<A>> buildJWEPayload(Function<A, Mono<String>> overridingPayloadEncoder, String overridingContentType, GenericJWEHeader jweHeader) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        this.checkPayload();
        return this.getPayloadEncoder(overridingPayloadEncoder, overridingContentType, jweHeader).apply(this.payload).onErrorMap(e -> new JWEBuildException("Failed to encode JWE payload", (Throwable)e)).map(rawPayload -> {
            GenericJWEPayload<Object> jwePayload = new GenericJWEPayload<Object>(this.payload);
            jwePayload.setRaw((String)rawPayload);
            return jwePayload;
        });
    }

    protected JWEZip getPayloadZip(GenericJWEHeader jweHeader) throws JWEBuildException {
        if (StringUtils.isBlank((CharSequence)jweHeader.getCompressionAlgorithm())) {
            return null;
        }
        return this.zips.stream().filter(z -> z.supports(jweHeader.getCompressionAlgorithm())).findFirst().orElseThrow(() -> new JWEBuildException("No JWE zip found supporting compression algorithm: " + jweHeader.getCompressionAlgorithm()));
    }

    protected Flux<? extends JWK> generateCEK(GenericJWEHeader jweHeader) throws JWKGenerateException {
        return Flux.from(this.jwkService.generate(jweHeader.getEncryptionAlgorithm(), Map.of("secureRandom", this.secureRandom)));
    }

    protected void amendJWEHeader(GenericJWEHeader header, Map<String, Object> moreHeaderParameters, Set<String> processedParameters) throws JWEBuildException, JOSEObjectBuildException, JOSEProcessingException {
        try {
            if (moreHeaderParameters != null) {
                moreHeaderParameters.forEach((k, v) -> header.addCustomParameter((String)k, v));
            }
            header.setExtraProcessedParameters(processedParameters);
            header.setRaw(this.mapper.writeValueAsBytes((Object)header));
        }
        catch (JsonProcessingException e) {
            throw new JWEBuildException("Failed to encode JWE header", e);
        }
    }

    protected byte[] getAdditionalAuthenticationData(GenericJWEHeader jweHeader) {
        return jweHeader.getEncoded().getBytes(StandardCharsets.US_ASCII);
    }

    protected JWACipher.EncryptedData zipAndEncryptPayload(GenericJWEHeader jweHeader, GenericJWEPayload<A> jwePayload, JWEZip payloadZip, JWK cek) throws JWKProcessingException, JWEZipException, JWACipherException {
        byte[] aad = this.getAdditionalAuthenticationData(jweHeader);
        JWACipher cipher = cek.cipher(jweHeader.getEncryptionAlgorithm());
        JWACipher.EncryptedData encryptedData = cipher.encrypt(payloadZip != null ? payloadZip.compress(jwePayload.getRaw().getBytes()) : jwePayload.getRaw().getBytes(), aad, this.secureRandom);
        jwePayload.setEncoded(JOSEUtils.BASE64_NOPAD_URL_ENCODER.encodeToString(encryptedData.getCipherText()));
        return encryptedData;
    }
}

