/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.security.jose.internal.jwa;

import io.inverno.mod.security.jose.internal.jwa.AbstractJWASigner;
import io.inverno.mod.security.jose.jwa.ECAlgorithm;
import io.inverno.mod.security.jose.jwa.JWAProcessingException;
import io.inverno.mod.security.jose.jwa.JWASignatureException;
import io.inverno.mod.security.jose.jwk.ec.ECJWK;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class ECSigner
extends AbstractJWASigner<ECJWK, ECAlgorithm> {
    public ECSigner(ECJWK jwk, ECAlgorithm algorithm) throws JWAProcessingException {
        super(jwk, algorithm);
        if (!jwk.getCurve().equals(algorithm.getCurve().getCurve())) {
            throw new JWAProcessingException("JWK with curve " + jwk.getCurve() + " does not support algorithm " + String.valueOf(algorithm));
        }
        this.init();
    }

    protected ECSigner(ECJWK jwk) {
        super(jwk);
    }

    @Override
    protected final void init() throws JWAProcessingException {
    }

    @Override
    protected byte[] doSign(byte[] data) throws JWASignatureException {
        return ((ECJWK)this.jwk).toPrivateKey().map(privateKey -> {
            try {
                Signature sig = Signature.getInstance(((ECAlgorithm)this.algorithm).getJcaAlgorithm());
                sig.initSign((PrivateKey)privateKey);
                sig.update(data);
                return this.signatureFromDer(sig.sign());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw new JWASignatureException(e);
            }
        }).orElseThrow(() -> new JWASignatureException("JWK is missing EC private key"));
    }

    @Override
    protected boolean doVerify(byte[] data, byte[] signature) throws JWASignatureException {
        try {
            Signature sig = Signature.getInstance(((ECAlgorithm)this.algorithm).getJcaAlgorithm());
            sig.initVerify((PublicKey)((ECJWK)this.jwk).toPublicKey());
            sig.update(data);
            return sig.verify(this.signatureToDER(signature));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWASignatureException(e);
        }
    }

    public byte[] signatureFromDer(byte[] derSignature) throws JWASignatureException {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JWASignatureException("Invalid DER signature");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new JWASignatureException("Invalid DER signature");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, ((ECAlgorithm)this.algorithm).getCurve().getSignatureLength() / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JWASignatureException("Invalid DER signature");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    private byte[] signatureToDER(byte[] signature) throws JWASignatureException {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = signature.length / 2; i > 0 && signature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (signature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && signature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (signature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new JWASignatureException("Invalid JOSE object signature");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(signature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(signature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }
}

